/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Map;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ElementFacetSource;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.swagger2.mappers.CollectionSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.CompoundSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.MapSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ReferenceModelSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.ScalarModelToPropertyConverter;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper
public class PropertyMapper {
    public Property fromModel(ModelSpecification modelSpecification, @Context ModelNamesRegistry modelNamesRegistry) {
        if (modelSpecification == null) {
            return null;
        }
        Property property = modelSpecification.getScalar().map(sm -> new ScalarModelToPropertyConverter().convert((ScalarModelSpecification)sm)).orElse(null);
        if (property == null) {
            property = modelSpecification.getCompound().map(cm -> new CompoundSpecificationToPropertyConverter(modelNamesRegistry).convert((CompoundModelSpecification)cm)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getMap().map(mm -> new MapSpecificationToPropertyConverter(modelNamesRegistry).convert((MapSpecification)mm)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getCollection().map(cm -> new CollectionSpecificationToPropertyConverter(modelNamesRegistry).convert((CollectionSpecification)cm)).orElse(null);
        }
        if (property == null) {
            property = modelSpecification.getReference().map(cm -> new ReferenceModelSpecificationToPropertyConverter(modelNamesRegistry).convert((ReferenceModelSpecification)cm)).orElse(null);
        }
        if (property != null) {
            property.setName(modelSpecification.getName());
            EnumMapper.maybeAddFacets(property, modelSpecification.getFacets().orElse(null));
        }
        return property;
    }

    public Property fromProperty(PropertySpecification source, @Context ModelNamesRegistry modelNamesRegistry) {
        Property property = this.fromModel(source.getType(), modelNamesRegistry);
        ModelFacets facets = source.getType().getFacets().orElse(null);
        EnumMapper.maybeAddFacets(property, (ElementFacetSource)facets);
        EnumMapper.maybeAddFacets(property, (ElementFacetSource)source);
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            EnumMapper.maybeAddFacets(arrayProperty.getItems(), source.getType().getCollection().flatMap(c -> c.getModel().getFacets()).orElse(null));
        }
        if (property instanceof MapProperty) {
            MapProperty mapProperty = (MapProperty)property;
            EnumMapper.maybeAddFacets(mapProperty.getAdditionalProperties(), source.getType().getMap().flatMap(c -> c.getValue().getFacets()).orElse(null));
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            stringProperty.setDefault(source.getDefaultValue() != null ? String.valueOf(source.getDefaultValue()) : null);
        }
        Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(source.getVendorExtensions());
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setRequired(source.getRequired() == null ? false : source.getRequired());
            property.setReadOnly(source.getReadOnly());
            property.setAllowEmptyValue(source.getAllowEmptyValue());
            property.setExample(source.getExample());
            property.getVendorExtensions().putAll(extensions);
            property.setXml(this.mapXml(source.getXml()));
        }
        return property;
    }

    private io.swagger.models.Xml mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new io.swagger.models.Xml().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }
}

