/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.inflector.config.ControllerFactory;
import io.swagger.inflector.config.DefaultControllerFactory;
import io.swagger.inflector.converters.InputConverter;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private final Map<String, Class<?>> modelMap = new HashMap();
    private Set<Class<?>> exceptionMappers = new HashSet();
    private String controllerPackage;
    private String controllerClass;
    private String modelPackage;
    private String swaggerUrl;
    private String filterClass;
    private int invalidRequestCode = 400;
    private String rootPath = "";
    private Environment environment = Environment.DEVELOPMENT;
    private Set<String> unimplementedModels = new HashSet<String>();
    private List<String> inputConverters = new ArrayList<String>();
    private List<String> inputValidators = new ArrayList<String>();
    private List<String> entityProcessors = new ArrayList<String>();
    private ControllerFactory controllerFactory = new DefaultControllerFactory();
    private String swaggerBase = "/";
    private boolean validatePayloads = false;

    public String getSwaggerBase() {
        return this.swaggerBase;
    }

    public static Configuration read() {
        String configLocation = System.getProperty("config", "inflector.yaml");
        System.out.println("loading inflector config from " + configLocation);
        if (configLocation != null) {
            try {
                return Configuration.read(configLocation);
            }
            catch (Exception e) {
                LOGGER.warn("couldn't read inflector config from system property");
            }
        }
        try {
            InputStream is = Configuration.class.getClassLoader().getResourceAsStream("/WEB-INF/inflector.yaml");
            if (is != null) {
                try {
                    return (Configuration)Yaml.mapper().readValue(is, Configuration.class);
                }
                catch (Exception e) {
                    LOGGER.warn("couldn't read inflector config from resource stream");
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Returning default configuration!");
        }
        return Configuration.defaultConfiguration();
    }

    public static Configuration read(String configLocation) throws Exception {
        String environment;
        Configuration config = (Configuration)Yaml.mapper().readValue(new File(configLocation), Configuration.class);
        if (config != null && config.getExceptionMappers().size() == 0) {
            config.setExceptionMappers(Configuration.defaultConfiguration().getExceptionMappers());
        }
        if ((environment = System.getProperty("environment")) != null) {
            System.out.println("Overriding environment to " + environment);
            config.setEnvironment(Environment.valueOf(environment));
        }
        return config;
    }

    public static Configuration defaultConfiguration() {
        return new Configuration().controllerPackage("io.swagger.sample.controllers").modelPackage("io.swagger.sample.models").swaggerUrl("swagger.yaml").exceptionMapper("io.swagger.inflector.utils.DefaultExceptionMapper").defaultValidators().defaultConverters().defaultProcessors();
    }

    public Configuration defaultValidators() {
        InputConverter.getInstance().defaultValidators();
        return this;
    }

    public Configuration defaultConverters() {
        InputConverter.getInstance().defaultConverters();
        return this;
    }

    public Configuration defaultProcessors() {
        InputConverter.getInstance().defaultValidators();
        return this;
    }

    public Configuration modelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
        return this;
    }

    public Configuration controllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
        return this;
    }

    public Configuration filterClass(String filterClass) {
        this.filterClass = filterClass;
        return this;
    }

    public Configuration modelMap(String name, Class<?> cls) {
        this.modelMap.put(name, cls);
        return this;
    }

    public Configuration controllerFactory(ControllerFactory instantiator) {
        this.controllerFactory = instantiator;
        return this;
    }

    public Configuration swaggerUrl(String swaggerUrl) {
        this.swaggerUrl = swaggerUrl;
        return this;
    }

    public Configuration exceptionMapper(String className) {
        try {
            ClassLoader classLoader = Configuration.class.getClassLoader();
            Class<?> cls = classLoader.loadClass(className);
            this.exceptionMappers.add(cls);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("unable to add exception mapper for `" + className + "`, " + e.getMessage());
        }
        return this;
    }

    public ControllerFactory getControllerFactory() {
        return this.controllerFactory;
    }

    public void setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
    }

    public void setControllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
    }

    public String getControllerPackage() {
        return this.controllerPackage;
    }

    public String getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(String controllerClass) {
        this.controllerClass = controllerClass;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public void setModelMappings(Map<String, String> mappings) {
        for (String key : mappings.keySet()) {
            String className = mappings.get(key);
            try {
                ClassLoader classLoader = Configuration.class.getClassLoader();
                Class<?> cls = classLoader.loadClass(className);
                this.modelMap.put(key, cls);
            }
            catch (ClassNotFoundException e) {
                this.unimplementedModels.add(className);
                LOGGER.error("unable to add mapping for `" + key + "` : `" + className + "`, " + e.getMessage());
            }
        }
    }

    public Map<String, String> getModelMappings() {
        HashMap<String, String> output = new HashMap<String, String>();
        for (String key : this.modelMap.keySet()) {
            Class<?> value = this.modelMap.get(key);
            output.put(key, value.getCanonicalName());
        }
        return output;
    }

    @JsonIgnore
    public void addModelMapping(String name, Class<?> cls) {
        this.modelMap.put(name, cls);
    }

    public Class<?> getModelMapping(String name) {
        return this.modelMap.get(name);
    }

    public String getSwaggerUrl() {
        if (System.getProperty("swaggerUrl") != null) {
            return System.getProperty("swaggerUrl");
        }
        return this.swaggerUrl;
    }

    public void setSwaggerUrl(String swaggerUrl) {
        this.swaggerUrl = swaggerUrl;
    }

    public void setInvalidRequestStatusCode(int code) {
        this.invalidRequestCode = code;
    }

    public int getInvalidRequestStatusCode() {
        return this.invalidRequestCode;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Set<Class<?>> getExceptionMappers() {
        return this.exceptionMappers;
    }

    public void setExceptionMappers(Set<Class<?>> exceptionMappers) {
        this.exceptionMappers = exceptionMappers;
    }

    public List<String> getEntityProcessors() {
        return this.entityProcessors;
    }

    public void setEntityProcessors(List<String> entityProcessors) {
        this.entityProcessors = entityProcessors;
    }

    public List<String> getInputValidators() {
        return this.inputValidators;
    }

    public void setInputValidators(List<String> inputValidators) {
        this.inputValidators = inputValidators;
    }

    public List<String> getInputConverters() {
        return this.inputConverters;
    }

    public void setInputConverters(List<String> inputConverters) {
        this.inputConverters = inputConverters;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Set<String> getUnimplementedModels() {
        return this.unimplementedModels;
    }

    public void setUnimplementedModels(Set<String> unimplementedModels) {
        this.unimplementedModels = unimplementedModels;
    }

    public void setSwaggerBase(String swaggerBase) {
        this.swaggerBase = swaggerBase;
    }

    public boolean isValidatePayloads() {
        return this.validatePayloads;
    }

    public void setValidatePayloads(boolean validatePayloads) {
        this.validatePayloads = validatePayloads;
    }

    public static enum Environment {
        DEVELOPMENT(1, "development"),
        STAGING(2, "staging"),
        PRODUCTION(3, "production");

        private Integer id;
        private String name;

        private Environment(Integer id, String name) {
            this.id = id;
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }
}

