/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.api;

import io.tarantool.driver.exceptions.TarantoolSocketException;
import java.io.Serializable;
import java.net.InetSocketAddress;

public class TarantoolServerAddress
implements Serializable {
    private static final long serialVersionUID = 7327851568010264254L;
    private final InetSocketAddress socketAddress;

    public TarantoolServerAddress() {
        this("127.0.0.1", 3301);
    }

    public TarantoolServerAddress(String host, int port) {
        this.socketAddress = new InetSocketAddress(host, port);
    }

    public TarantoolServerAddress(String address) {
        int lastIdx;
        int idx;
        String hostToUse = this.splitHostByUser(address);
        Integer portToUse = null;
        if (hostToUse.startsWith("[")) {
            idx = address.indexOf("]");
            if (idx == -1) {
                throw new IllegalArgumentException("An IPV6 address must be enclosed with '[' and ']' according to RFC 2732.");
            }
            int portIdx = address.indexOf("]:");
            if (portIdx != -1) {
                try {
                    portToUse = Integer.parseInt(address.substring(portIdx + 2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid address: %s", address));
                }
            }
            hostToUse = address.substring(1, idx);
        }
        if ((idx = hostToUse.indexOf(":")) == (lastIdx = hostToUse.lastIndexOf(":")) && idx > 0) {
            try {
                portToUse = Integer.parseInt(hostToUse.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid address: %s", address));
            }
            hostToUse = hostToUse.substring(0, idx).trim();
        }
        if (portToUse == null) {
            throw new IllegalArgumentException(String.format("Invalid address: %s", address));
        }
        this.socketAddress = new InetSocketAddress(hostToUse.toLowerCase(), (int)portToUse);
    }

    private String splitHostByUser(String host) {
        String hostToUse = host;
        if (hostToUse == null) {
            throw new IllegalArgumentException("Host is null");
        }
        String[] split = hostToUse.split("@");
        if (split.length > 2) {
            throw new IllegalArgumentException(String.format("Incorrect address for connecting to Tarantool: %s", hostToUse));
        }
        if (split.length == 2) {
            hostToUse = split[1];
        }
        if (split.length == 1) {
            hostToUse = split[0];
        }
        if ((hostToUse = hostToUse.trim()).length() == 0) {
            throw new IllegalArgumentException("Host is empty");
        }
        return hostToUse;
    }

    public TarantoolServerAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public String getHost() {
        return this.socketAddress.getHostName();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public InetSocketAddress getSocketAddress() throws TarantoolSocketException {
        return this.socketAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TarantoolServerAddress that = (TarantoolServerAddress)o;
        return this.socketAddress.equals(that.socketAddress);
    }

    public int hashCode() {
        return this.socketAddress.hashCode();
    }

    public String toString() {
        return this.socketAddress.toString();
    }
}

