/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.cluster;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.cluster.AbstractDiscoveryClusterAddressProvider;
import io.tarantool.driver.cluster.HTTPClusterDiscoveryEndpoint;
import io.tarantool.driver.cluster.ServerNodeInfo;
import io.tarantool.driver.cluster.TarantoolClusterDiscoveryConfig;
import io.tarantool.driver.exceptions.TarantoolClientException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;

public class HTTPDiscoveryClusterAddressProvider
extends AbstractDiscoveryClusterAddressProvider {
    private URI uri;
    private int port;
    private String host;
    private String scheme;
    private final SslContext sslContext;
    private final EventLoopGroup eventLoopGroup;
    private final Bootstrap bootstrap;

    public HTTPDiscoveryClusterAddressProvider(TarantoolClusterDiscoveryConfig config) {
        super(config);
        HTTPClusterDiscoveryEndpoint endpoint = (HTTPClusterDiscoveryEndpoint)config.getEndpoint();
        try {
            this.parseUri(endpoint.getUri());
            this.sslContext = "https".equalsIgnoreCase(this.scheme) ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        }
        catch (URISyntaxException | SSLException e) {
            throw new TarantoolClientException("Incorrect url %s, %s", endpoint.getUri(), e.getMessage());
        }
        this.eventLoopGroup = new NioEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)endpoint.getConnectTimeout());
        this.startDiscoveryTask();
    }

    private void parseUri(String uri) throws URISyntaxException, TarantoolClientException {
        this.uri = new URI(uri);
        this.scheme = this.uri.getScheme() == null ? "http" : this.uri.getScheme();
        this.host = this.uri.getHost() == null ? "127.0.0.1" : this.uri.getHost();
        this.port = this.uri.getPort();
        if (this.port == -1) {
            if ("http".equalsIgnoreCase(this.scheme)) {
                this.port = 80;
            } else if ("https".equalsIgnoreCase(this.scheme)) {
                this.port = 443;
            }
        }
        if (!"http".equalsIgnoreCase(this.scheme) && !"https".equalsIgnoreCase(this.scheme)) {
            throw new TarantoolClientException("Only HTTP(S) is supported. (%s)", uri);
        }
    }

    @Override
    protected Collection<TarantoolServerAddress> discoverAddresses() {
        try {
            CompletableFuture<Map<String, ServerNodeInfo>> completableFuture = this.sendRequest();
            Map<String, ServerNodeInfo> addressMap = completableFuture.get();
            return addressMap.values().stream().filter(ServerNodeInfo::isAvailable).map(v -> new TarantoolServerAddress(v.getUri())).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TarantoolClientException("Cluster discovery task error", e);
        }
    }

    private CompletableFuture<Map<String, ServerNodeInfo>> sendRequest() throws InterruptedException {
        CompletableFuture<Map<String, ServerNodeInfo>> completableFuture = new CompletableFuture<Map<String, ServerNodeInfo>>();
        TarantoolClusterDiscoveryConfig config = this.getDiscoveryConfig();
        HTTPClusterDiscoveryEndpoint endpoint = (HTTPClusterDiscoveryEndpoint)config.getEndpoint();
        this.getExecutorService().schedule(() -> {
            if (!completableFuture.isDone()) {
                completableFuture.completeExceptionally(new TimeoutException(String.format("Failed to get response for request in %d ms", endpoint.getReadTimeout())));
            }
        }, (long)endpoint.getReadTimeout(), TimeUnit.MILLISECONDS);
        Bootstrap bootstrap = (Bootstrap)this.bootstrap.clone().handler((ChannelHandler)new SimpleHttpClientInitializer(this.sslContext, completableFuture));
        Channel ch = bootstrap.connect(this.host, this.port).sync().channel();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.uri.getRawPath(), Unpooled.EMPTY_BUFFER);
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        ch.writeAndFlush((Object)request);
        ch.closeFuture().sync();
        return completableFuture;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException("Interrupted while shutting down the discovery service");
        }
    }

    private static class SimpleHttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private final CompletableFuture<Map<String, ServerNodeInfo>> completableFuture;
        private final SslContext sslCtx;

        SimpleHttpClientInitializer(SslContext sslCtx, CompletableFuture<Map<String, ServerNodeInfo>> completableFuture) {
            this.sslCtx = sslCtx;
            this.completableFuture = completableFuture;
        }

        public void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            if (this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpClientCodec()});
            p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
            p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
            p.addLast(new ChannelHandler[]{new SimpleHttpClientHandler(this.completableFuture)});
        }
    }

    private static class SimpleHttpClientHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private final CompletableFuture<Map<String, ServerNodeInfo>> completableFuture;
        private final ObjectMapper objectMapper = new ObjectMapper();

        SimpleHttpClientHandler(CompletableFuture<Map<String, ServerNodeInfo>> completableFuture) {
            this.completableFuture = completableFuture;
        }

        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
            if (msg instanceof HttpContent) {
                Map responseMap;
                HttpContent content = (HttpContent)msg;
                String contentString = content.content().toString(CharsetUtil.UTF_8);
                TypeReference<HashMap<String, ServerNodeInfo>> typeReference = new TypeReference<HashMap<String, ServerNodeInfo>>(){};
                try {
                    responseMap = (Map)this.objectMapper.readValue(contentString, (TypeReference)typeReference);
                }
                catch (Exception e) {
                    throw new TarantoolClientException("Cluster discovery task error", e);
                }
                this.completableFuture.complete(responseMap);
                if (content instanceof LastHttpContent) {
                    ctx.close();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
            this.completableFuture.completeExceptionally(cause);
        }
    }
}

