/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.tarantool.driver.protocol.TarantoolResponse;
import java.nio.ByteBuffer;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ByteBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

public class MessagePackFrameDecoder
extends ByteToMessageDecoder {
    private static final int MINIMAL_HEADER_SIZE = 5;
    private static final int MINIMAL_BODY_SIZE = 0x100000;
    private int size;
    private final ByteBuffer lenBuffer = ByteBuffer.allocateDirect(5);
    private final ByteBufferInput lenBufferInput = new ByteBufferInput(this.lenBuffer);
    private final MessageUnpacker lenUnpacker = new MessagePack.UnpackerConfig().newUnpacker((MessageBufferInput)this.lenBufferInput);
    private final ByteBuffer bodyBuffer = ByteBuffer.allocateDirect(0x100000);
    private final ByteBufferInput bodyBufferInput = new ByteBufferInput(this.bodyBuffer);
    private final MessageUnpacker bodyUnpacker = new MessagePack.UnpackerConfig().newUnpacker((MessageBufferInput)this.bodyBufferInput);

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() < 5) {
            return;
        }
        byteBuf.markReaderIndex();
        this.lenBuffer.clear();
        this.lenBufferInput.reset(this.lenBuffer);
        this.lenUnpacker.reset((MessageBufferInput)this.lenBufferInput);
        byteBuf.readBytes(this.lenBuffer);
        this.size = this.lenUnpacker.unpackInt();
        if (byteBuf.readableBytes() < this.size) {
            byteBuf.resetReaderIndex();
            return;
        }
        this.bodyBuffer.clear();
        this.bodyBuffer.limit(this.size);
        this.bodyBufferInput.reset(this.bodyBuffer);
        this.bodyUnpacker.reset((MessageBufferInput)this.bodyBufferInput);
        byteBuf.readBytes(this.bodyBuffer);
        list.add(TarantoolResponse.fromMessagePack(this.bodyUnpacker));
        this.size = 0;
    }
}

