/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolRequest;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.buffer.ArrayBufferOutput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class MessagePackFrameEncoder
extends MessageToByteEncoder<TarantoolRequest> {
    private static final int MINIMAL_HEADER_SIZE = 8;
    private static final int MINIMAL_BODY_SIZE = 0x100000;
    private final MessagePackObjectMapper mapper;
    private final ArrayBufferOutput lenBufferOutput = new ArrayBufferOutput(8);
    private final MessagePacker lenPacker = new MessagePack.PackerConfig().newPacker((MessageBufferOutput)this.lenBufferOutput);
    private final ArrayBufferOutput bodyBufferOutput = new ArrayBufferOutput(0x100000);
    private final MessagePacker bodyPacker = new MessagePack.PackerConfig().newPacker((MessageBufferOutput)this.bodyBufferOutput);

    public MessagePackFrameEncoder(MessagePackObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected void encode(ChannelHandlerContext ctx, TarantoolRequest tarantoolRequest, ByteBuf byteBuf) throws Exception {
        this.bodyBufferOutput.clear();
        this.bodyPacker.clear();
        tarantoolRequest.toMessagePack(this.bodyPacker, this.mapper);
        this.bodyPacker.flush();
        MessageBuffer bodyBuffer = this.bodyBufferOutput.toMessageBuffer();
        this.lenBufferOutput.clear();
        this.lenPacker.clear();
        this.lenPacker.packLong((long)bodyBuffer.size());
        this.lenPacker.flush();
        MessageBuffer lenBuffer = this.lenBufferOutput.toMessageBuffer();
        byteBuf.capacity(bodyBuffer.size() + lenBuffer.size());
        byteBuf.writeBytes(this.lenBufferOutput.toMessageBuffer().sliceAsByteBuffer(0, lenBuffer.size()));
        byteBuf.writeBytes(this.bodyBufferOutput.toMessageBuffer().sliceAsByteBuffer(0, bodyBuffer.size()));
    }
}

