/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.api.CallResult;
import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.api.connection.TarantoolConnection;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.space.TarantoolSpaceOperations;
import io.tarantool.driver.core.TarantoolDaemonThreadFactory;
import io.tarantool.driver.core.connection.TarantoolConnectionFactory;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.core.metadata.SpacesMetadataProvider;
import io.tarantool.driver.core.metadata.TarantoolMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolSpaceNotFoundException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactoryImpl;
import io.tarantool.driver.protocol.Packable;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequestSignature;
import io.tarantool.driver.protocol.requests.TarantoolCallRequest;
import io.tarantool.driver.protocol.requests.TarantoolEvalRequest;
import io.tarantool.driver.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.msgpack.value.Value;

public abstract class AbstractTarantoolClient<T extends Packable, R extends Collection<T>>
implements TarantoolClient<T, R> {
    private final NioEventLoopGroup eventLoopGroup;
    private final TarantoolClientConfig config;
    private final Bootstrap bootstrap;
    private final TarantoolConnectionFactory connectionFactory;
    private final TarantoolConnectionListeners listeners;
    private final AtomicReference<TarantoolMetadata> metadataHolder = new AtomicReference();
    private final ResultMapperFactoryFactoryImpl mapperFactoryFactory;
    private final Map<TarantoolRequestSignature, MessagePackObjectMapper> argumentsMapperCache;
    private final Map<TarantoolRequestSignature, MessagePackValueMapper> resultMapperCache;
    private final SpacesMetadataProvider metadataProvider;
    private final ScheduledExecutorService timeoutScheduler;
    private TarantoolConnectionManager connectionManager;

    public AbstractTarantoolClient(TarantoolClientConfig config) {
        this(config, new TarantoolConnectionListeners());
    }

    protected AbstractTarantoolClient(TarantoolClientConfig config, ConnectionSelectionStrategyFactory selectionStrategyFactory, TarantoolConnectionListeners listeners) {
        this(config, listeners);
    }

    public AbstractTarantoolClient(TarantoolClientConfig config, TarantoolConnectionListeners listeners) {
        Assert.notNull(config, "Tarantool client config must not be null");
        Assert.notNull(listeners, "Tarantool connection listeners must not be null");
        this.config = config;
        this.mapperFactoryFactory = new ResultMapperFactoryFactoryImpl();
        this.argumentsMapperCache = new ConcurrentHashMap<TarantoolRequestSignature, MessagePackObjectMapper>();
        this.resultMapperCache = new ConcurrentHashMap<TarantoolRequestSignature, MessagePackValueMapper>();
        this.eventLoopGroup = new NioEventLoopGroup(config.getEventLoopThreadsNumber());
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        this.timeoutScheduler = Executors.newSingleThreadScheduledExecutor(new TarantoolDaemonThreadFactory("tarantool-timeout"));
        this.connectionFactory = new TarantoolConnectionFactory(config, this.bootstrap, this.timeoutScheduler);
        this.listeners = listeners;
        this.metadataProvider = new SpacesMetadataProvider(this, config.getMessagePackMapper());
    }

    protected abstract TarantoolConnectionManager connectionManager(TarantoolClientConfig var1, TarantoolConnectionFactory var2, TarantoolConnectionListeners var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TarantoolConnectionManager connectionManager() {
        if (this.connectionManager == null) {
            AbstractTarantoolClient abstractTarantoolClient = this;
            synchronized (abstractTarantoolClient) {
                if (this.connectionManager == null) {
                    this.connectionManager = this.connectionManager(this.config, this.connectionFactory, this.listeners);
                }
            }
        }
        return this.connectionManager;
    }

    @Override
    public boolean refresh() {
        return this.connectionManager().refresh();
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        try {
            return (TarantoolVersion)((CompletableFuture)this.connectionManager().getConnection().thenApply(TarantoolConnection::getVersion)).get();
        }
        catch (InterruptedException e) {
            throw new TarantoolClientException(e);
        }
        catch (ExecutionException e) {
            throw new TarantoolClientException(e.getCause());
        }
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(String spaceName) throws TarantoolClientException {
        Assert.hasText(spaceName, "Space name must not be null or empty");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceByName(spaceName);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceName);
        }
        return this.spaceOperations(this.config, this.connectionManager(), metadata, meta.get());
    }

    @Override
    public TarantoolSpaceOperations<T, R> space(int spaceId) throws TarantoolClientException {
        Assert.state(spaceId > 0, "Space ID must be greater than 0");
        TarantoolMetadataOperations metadata = this.metadata();
        Optional<TarantoolSpaceMetadata> meta = metadata.getSpaceById(spaceId);
        if (!meta.isPresent()) {
            throw new TarantoolSpaceNotFoundException(spaceId);
        }
        return this.spaceOperations(this.config, this.connectionManager(), metadata, meta.get());
    }

    protected abstract TarantoolSpaceOperations<T, R> spaceOperations(TarantoolClientConfig var1, TarantoolConnectionManager var2, TarantoolMetadataOperations var3, TarantoolSpaceMetadata var4);

    @Override
    public TarantoolMetadataOperations metadata() throws TarantoolClientException {
        if (this.metadataHolder.get() == null) {
            this.metadataHolder.compareAndSet(null, new TarantoolMetadata(this.metadataProvider()));
        }
        return this.metadataHolder.get();
    }

    @Override
    public TarantoolMetadataProvider metadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName) throws TarantoolClientException {
        return this.makeRequest(functionName, Collections.emptyList(), null, this.config::getMessagePackMapper, this.config::getMessagePackMapper);
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, Object ... arguments) throws TarantoolClientException {
        return this.call(functionName, Arrays.asList(arguments));
    }

    @Override
    public CompletableFuture<List<?>> call(String functionName, Collection<?> arguments) throws TarantoolClientException {
        return this.makeRequest(functionName, arguments, null, this.config::getMessagePackMapper, this.config::getMessagePackMapper);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, Class<T> tupleClass) throws TarantoolClientException {
        return this.callForTupleResult(functionName, Collections.emptyList(), tupleClass);
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) throws TarantoolClientException {
        return this.call(functionName, Collections.emptyList(), resultMapperSupplier);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, Collection<?> arguments, Class<T> tupleClass) throws TarantoolClientException {
        return this.callForTupleResult(functionName, arguments, this.config::getMessagePackMapper, tupleClass);
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, Collection<?> arguments, Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) throws TarantoolClientException {
        return this.call(functionName, arguments, this.config::getMessagePackMapper, resultMapperSupplier);
    }

    @Override
    public <T> CompletableFuture<TarantoolResult<T>> callForTupleResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Class<T> tupleClass) throws TarantoolClientException {
        TarantoolRequestSignature signature = TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier, tupleClass);
        Supplier resultMapperSupplier = () -> this.mapperFactoryFactory.getTarantoolResultMapper(this.config.getMessagePackMapper(), tupleClass);
        return this.callForSingleResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier);
    }

    @Override
    public <T> CompletableFuture<T> call(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, argumentsMapperSupplier, resultMapperSupplier);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, Class<S> resultClass) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, (Supplier<? extends MessagePackObjectMapper>)((Supplier<MessagePackObjectMapper>)this.config::getMessagePackMapper), resultClass);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, ValueConverter<Value, S> valueConverter) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, (Supplier<? extends MessagePackObjectMapper>)((Supplier<MessagePackObjectMapper>)this.config::getMessagePackMapper), valueConverter);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier) throws TarantoolClientException {
        return this.callForSingleResult(functionName, arguments, (Supplier<? extends MessagePackObjectMapper>)((Supplier<MessagePackObjectMapper>)this.config::getMessagePackMapper), resultMapperSupplier);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Class<S> resultClass) throws TarantoolClientException {
        return this.callForSingleResult(functionName, (Collection<?>)Collections.emptyList(), resultClass);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, ValueConverter<Value, S> valueConverter) throws TarantoolClientException {
        return this.callForSingleResult(functionName, (Collection<?>)Collections.emptyList(), valueConverter);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier) throws TarantoolClientException {
        return this.callForSingleResult(functionName, (Collection<?>)Collections.emptyList(), resultMapperSupplier);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Class<S> resultClass) throws TarantoolClientException {
        TarantoolRequestSignature signature = TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier, resultClass);
        Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier = () -> this.mapperFactoryFactory.getDefaultSingleValueMapper(this.config.getMessagePackMapper(), resultClass);
        return this.callForSingleResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, ValueConverter<Value, S> valueConverter) throws TarantoolClientException {
        TarantoolRequestSignature signature = TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier, valueConverter);
        Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier = () -> this.mapperFactoryFactory.getSingleValueResultMapper(valueConverter);
        return this.callForSingleResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier);
    }

    private <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, TarantoolRequestSignature signature, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier) throws TarantoolClientException {
        return this.makeRequestForSingleResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier).thenApply(CallResult::value);
    }

    public <S> CompletableFuture<S> callForSingleResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<S, SingleValueCallResult<S>>> resultMapperSupplier) throws TarantoolClientException {
        return this.makeRequestForSingleResult(functionName, arguments, null, argumentsMapperSupplier, resultMapperSupplier).thenApply(CallResult::value);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, this.config::getMessagePackMapper, resultContainerSupplier, resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, this.config::getMessagePackMapper, resultContainerSupplier, valueConverter);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier) throws TarantoolClientException {
        return this.callForMultiResult(functionName, arguments, this.config::getMessagePackMapper, resultMapperSupplier);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.callForMultiResult(functionName, Collections.emptyList(), resultContainerSupplier, resultClass);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        return this.callForMultiResult(functionName, Collections.emptyList(), resultContainerSupplier, valueConverter);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier) throws TarantoolClientException {
        return this.callForMultiResult(functionName, Collections.emptyList(), resultMapperSupplier);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<R> resultContainerSupplier, Class<T> resultClass) throws TarantoolClientException {
        TarantoolRequestSignature signature = TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier, resultContainerSupplier, resultClass);
        Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier = () -> this.mapperFactoryFactory.getDefaultMultiValueMapper(this.config.getMessagePackMapper(), resultClass);
        return this.callForMultiResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<R> resultContainerSupplier, ValueConverter<Value, T> valueConverter) throws TarantoolClientException {
        TarantoolRequestSignature signature = TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier, resultContainerSupplier, valueConverter);
        Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier = () -> this.mapperFactoryFactory.getMultiValueResultMapper(resultContainerSupplier, valueConverter);
        return this.callForMultiResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier);
    }

    private <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, TarantoolRequestSignature signature, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier) throws TarantoolClientException {
        return this.makeRequestForMultiResult(functionName, arguments, signature, argumentsMapperSupplier, resultMapperSupplier).thenApply(CallResult::value);
    }

    @Override
    public <T, R extends List<T>> CompletableFuture<R> callForMultiResult(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier) throws TarantoolClientException {
        return this.makeRequestForMultiResult(functionName, arguments, null, argumentsMapperSupplier, resultMapperSupplier).thenApply(CallResult::value);
    }

    private <T> CompletableFuture<CallResult<T>> makeRequestForSingleResult(String functionName, Collection<?> arguments, TarantoolRequestSignature requestSignature, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) {
        return this.makeRequest(functionName, arguments, requestSignature, argumentsMapperSupplier, resultMapperSupplier);
    }

    private <T, R extends List<T>> CompletableFuture<CallResult<R>> makeRequestForMultiResult(String functionName, Collection<?> arguments, TarantoolRequestSignature requestSignature, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<R, MultiValueCallResult<T, R>>> resultMapperSupplier) {
        return this.makeRequest(functionName, arguments, requestSignature, argumentsMapperSupplier, resultMapperSupplier);
    }

    private <S> CompletableFuture<S> makeRequest(String functionName, Collection<?> arguments, TarantoolRequestSignature requestSignature, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<? extends MessagePackValueMapper> resultMapperSupplier) throws TarantoolClientException {
        try {
            TarantoolCallRequest.Builder builder = new TarantoolCallRequest.Builder().withFunctionName(functionName);
            if (arguments.size() > 0) {
                builder.withArguments(arguments);
            }
            builder.withSignature(requestSignature);
            MessagePackObjectMapper argumentsMapper = requestSignature != null ? this.argumentsMapperCache.computeIfAbsent(requestSignature, s -> (MessagePackObjectMapper)argumentsMapperSupplier.get()) : argumentsMapperSupplier.get();
            MessagePackValueMapper resultMapper = requestSignature != null ? this.resultMapperCache.computeIfAbsent(requestSignature, s -> (MessagePackValueMapper)resultMapperSupplier.get()) : resultMapperSupplier.get();
            TarantoolCallRequest request = builder.build(argumentsMapper);
            return ((CompletableFuture)this.connectionManager().getConnection().thenCompose(c -> c.sendRequest(request).getFuture())).thenApply(resultMapper::fromValue);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression) throws TarantoolClientException {
        return this.eval(expression, Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, Collection<?> arguments) throws TarantoolClientException {
        return this.eval(expression, arguments, this.config::getMessagePackMapper);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, Supplier<? extends MessagePackValueMapper> resultMapperSupplier) throws TarantoolClientException {
        return this.eval(expression, Collections.emptyList(), resultMapperSupplier);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, Collection<?> arguments, Supplier<? extends MessagePackValueMapper> resultMapperSupplier) throws TarantoolClientException {
        return this.eval(expression, arguments, this.config::getMessagePackMapper, resultMapperSupplier);
    }

    @Override
    public CompletableFuture<List<?>> eval(String expression, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<? extends MessagePackValueMapper> resultMapperSupplier) throws TarantoolClientException {
        try {
            TarantoolRequestSignature signature = TarantoolRequestSignature.create(expression, arguments, argumentsMapperSupplier, resultMapperSupplier);
            MessagePackObjectMapper argumentsMapper = this.argumentsMapperCache.computeIfAbsent(signature, s -> (MessagePackObjectMapper)argumentsMapperSupplier.get());
            MessagePackValueMapper resultMapper = this.resultMapperCache.computeIfAbsent(signature, s -> (MessagePackValueMapper)resultMapperSupplier.get());
            TarantoolEvalRequest request = ((TarantoolEvalRequest.Builder)new TarantoolEvalRequest.Builder().withExpression(expression).withArguments(arguments).withSignature(signature)).build(argumentsMapper);
            return ((CompletableFuture)this.connectionManager().getConnection().thenCompose(c -> c.sendRequest(request).getFuture())).thenApply(resultMapper::fromValue);
        }
        catch (TarantoolProtocolException e) {
            throw new TarantoolClientException(e);
        }
    }

    @Override
    public TarantoolClientConfig getConfig() {
        return this.config;
    }

    protected Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public void close() throws Exception {
        try {
            this.connectionManager().close();
            this.timeoutScheduler.shutdownNow();
        }
        finally {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    @Override
    public TarantoolConnectionListeners getConnectionListeners() {
        return this.listeners;
    }

    @Override
    public ResultMapperFactoryFactory getResultMapperFactoryFactory() {
        return this.mapperFactoryFactory;
    }
}

