/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.core.TarantoolRequestMetadata;
import io.tarantool.driver.protocol.TarantoolRequest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.msgpack.value.Value;

public class RequestFutureManager
implements AutoCloseable {
    private final ScheduledExecutorService timeoutScheduler;
    private final TarantoolClientConfig config;
    private final Map<Long, TarantoolRequestMetadata> requestFutures = new ConcurrentHashMap<Long, TarantoolRequestMetadata>();

    public RequestFutureManager(TarantoolClientConfig config, ScheduledExecutorService timeoutScheduler) {
        this.config = config;
        this.timeoutScheduler = timeoutScheduler;
    }

    public TarantoolRequestMetadata submitRequest(TarantoolRequest request) {
        return this.submitRequest(request, this.config.getRequestTimeout());
    }

    public TarantoolRequestMetadata submitRequest(TarantoolRequest request, int requestTimeout) {
        CompletableFuture<Value> requestFuture = new CompletableFuture<Value>();
        TarantoolRequestMetadata requestMetadata = new TarantoolRequestMetadata(request, requestFuture);
        long requestId = requestMetadata.getRequestId();
        requestFuture.whenComplete((r, e) -> this.requestFutures.remove(requestId));
        this.requestFutures.put(requestId, requestMetadata);
        this.timeoutScheduler.schedule(() -> {
            if (!requestFuture.isDone()) {
                requestFuture.completeExceptionally(new TimeoutException(String.format("Failed to get response for %s within %d ms", requestMetadata, requestTimeout)));
            }
        }, (long)requestTimeout, TimeUnit.MILLISECONDS);
        return requestMetadata;
    }

    public TarantoolRequestMetadata getRequest(Long requestId) {
        return this.requestFutures.get(requestId);
    }

    @Override
    public void close() {
        this.requestFutures.values().forEach(f -> f.getFuture().join());
    }
}

