/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core;

import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.api.tuple.TarantoolTupleResult;
import io.tarantool.driver.core.TarantoolResultImpl;
import io.tarantool.driver.exceptions.TarantoolTupleConversionException;
import io.tarantool.driver.mappers.converters.value.ArrayValueToTarantoolTupleConverter;
import java.util.stream.Collectors;
import org.msgpack.core.MessageTypeCastException;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public class TarantoolTupleResultImpl
extends TarantoolResultImpl<TarantoolTuple>
implements TarantoolTupleResult {
    protected TarantoolTupleResultImpl(ArrayValue rawTuples, TarantoolSpaceMetadata metadata, ArrayValueToTarantoolTupleConverter tupleConverter) {
        this.setItems(rawTuples, metadata, tupleConverter);
    }

    protected TarantoolTupleResultImpl(Value value, ArrayValueToTarantoolTupleConverter tupleConverter) {
        this.setItems(value.asArrayValue(), tupleConverter);
    }

    private void setItems(ArrayValue tupleArray, TarantoolSpaceMetadata responseMetadata, ArrayValueToTarantoolTupleConverter tupleConverter) {
        this.tuples = tupleArray.list().stream().map(v -> {
            try {
                return tupleConverter.fromValue(v.asArrayValue(), responseMetadata);
            }
            catch (MessageTypeCastException e) {
                throw new TarantoolTupleConversionException((Value)v, (Throwable)e);
            }
        }).collect(Collectors.toList());
    }
}

