/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.conditions;

import io.tarantool.driver.api.conditions.NamedField;
import io.tarantool.driver.api.metadata.TarantoolFieldMetadata;
import io.tarantool.driver.api.metadata.TarantoolMetadataOperations;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolFieldNotFoundException;
import io.tarantool.driver.utils.Assert;
import java.util.Objects;
import java.util.Optional;

public class NamedFieldImpl
implements NamedField {
    private static final long serialVersionUID = 20200708L;
    private final String name;

    public NamedFieldImpl(String name) {
        Assert.hasText(name, "Field name should not be empty");
        this.name = name;
    }

    @Override
    public TarantoolFieldMetadata metadata(TarantoolMetadataOperations metadataOperations, TarantoolSpaceMetadata spaceMetadata) {
        Optional<TarantoolFieldMetadata> fieldMetadata = spaceMetadata.getFieldByName(this.name);
        if (!fieldMetadata.isPresent()) {
            throw new TarantoolFieldNotFoundException(this.name, spaceMetadata);
        }
        return fieldMetadata.get();
    }

    @Override
    public String toIdentifier() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedFieldImpl that = (NamedFieldImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

