/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.connection;

import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategy;
import io.tarantool.driver.api.connection.ConnectionSelectionStrategyFactory;
import io.tarantool.driver.api.connection.TarantoolConnection;
import io.tarantool.driver.api.connection.TarantoolConnectionListeners;
import io.tarantool.driver.core.connection.ConnectionMode;
import io.tarantool.driver.core.connection.TarantoolConnectionFactory;
import io.tarantool.driver.core.connection.TarantoolConnectionManager;
import io.tarantool.driver.exceptions.NoAvailableConnectionsException;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.exceptions.TarantoolConnectionException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTarantoolConnectionManager
implements TarantoolConnectionManager {
    private final TarantoolClientConfig config;
    private final TarantoolConnectionFactory connectionFactory;
    private final ConnectionSelectionStrategyFactory selectStrategyFactory;
    private final TarantoolConnectionListeners connectionListeners;
    private Map<TarantoolServerAddress, List<TarantoolConnection>> connectionRegistry;
    private final AtomicReference<ConnectionSelectionStrategy> connectionSelectStrategy = new AtomicReference();
    private final AtomicReference<ConnectionMode> connectionMode = new AtomicReference<ConnectionMode>(ConnectionMode.FULL);
    private final Phaser initPhaser = new Phaser(0);
    private static final Logger logger = LoggerFactory.getLogger(AbstractTarantoolConnectionManager.class);

    public AbstractTarantoolConnectionManager(TarantoolClientConfig config, TarantoolConnectionFactory connectionFactory, TarantoolConnectionListeners connectionListeners) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.selectStrategyFactory = config.getConnectionSelectionStrategyFactory();
        this.connectionSelectStrategy.set(this.selectStrategyFactory.create(config, Collections.emptyList()));
        this.connectionListeners = connectionListeners;
        this.connectionRegistry = new HashMap<TarantoolServerAddress, List<TarantoolConnection>>();
    }

    protected abstract Collection<TarantoolServerAddress> getAddresses();

    @Override
    public CompletableFuture<TarantoolConnection> getConnection() {
        return this.getConnectionInternal().handle((connection, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                if (ex instanceof NoAvailableConnectionsException) {
                    this.connectionMode.compareAndSet(ConnectionMode.OFF, ConnectionMode.FULL);
                }
                throw new TarantoolConnectionException((Throwable)ex);
            }
            return connection;
        });
    }

    @Override
    public boolean refresh() {
        return this.connectionMode.compareAndSet(ConnectionMode.OFF, ConnectionMode.PARTIAL);
    }

    protected boolean areAddressesChanged() {
        Collection<TarantoolServerAddress> addresses = this.getAddresses();
        if (addresses == null) {
            logger.debug("The list of server addresses is not defined");
            return true;
        }
        return !this.connectionRegistry.keySet().equals(new HashSet<TarantoolServerAddress>(addresses));
    }

    protected boolean areConnectionsAlive() {
        for (List<TarantoolConnection> connections : this.connectionRegistry.values()) {
            int isAliveConnections = (int)connections.stream().filter(TarantoolConnection::isConnected).count();
            if (isAliveConnections == this.config.getConnections()) continue;
            return false;
        }
        return true;
    }

    private CompletableFuture<TarantoolConnection> getConnectionInternal() {
        CompletionStage<TarantoolConnection> result;
        ConnectionMode currentMode = this.connectionMode.get();
        if (this.initPhaser.getRegisteredParties() == 0 && (this.connectionMode.compareAndSet(ConnectionMode.FULL, ConnectionMode.IN_PROGRESS) || this.connectionMode.compareAndSet(ConnectionMode.PARTIAL, ConnectionMode.IN_PROGRESS))) {
            AtomicReference currentRegistry = new AtomicReference();
            logger.debug("Current connection mode: {}", (Object)currentMode);
            if (currentMode == ConnectionMode.FULL) {
                this.initPhaser.register();
            }
            result = ((CompletableFuture)((CompletableFuture)this.establishConnections().thenAccept(registry -> {
                if (currentMode == ConnectionMode.PARTIAL) {
                    this.initPhaser.register();
                }
                currentRegistry.set(this.connectionRegistry);
                this.connectionRegistry = registry;
                ConnectionSelectionStrategy strategy = this.selectStrategyFactory.create(this.config, registry.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                this.connectionSelectStrategy.set(strategy);
            })).thenApply(v -> this.connectionSelectStrategy.get().next())).whenComplete((v, ex) -> {
                if (ex != null) {
                    this.connectionMode.set(currentMode);
                } else {
                    this.closeOldConnections((Map)currentRegistry.get());
                }
                this.initPhaser.arriveAndDeregister();
                this.connectionMode.compareAndSet(ConnectionMode.IN_PROGRESS, ConnectionMode.OFF);
            });
        } else {
            this.initPhaser.awaitAdvance(this.initPhaser.getPhase());
            result = new CompletableFuture<TarantoolConnection>();
            try {
                result.complete(this.connectionSelectStrategy.get().next());
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }
        return result;
    }

    private CompletableFuture<Map<TarantoolServerAddress, List<TarantoolConnection>>> establishConnections() throws TarantoolClientException {
        CompletionStage<Map<TarantoolServerAddress, List<TarantoolConnection>>> result = new CompletableFuture<Map<TarantoolServerAddress, List<TarantoolConnection>>>();
        try {
            List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = this.getConnections();
            result = CompletableFuture.allOf(endpointConnections.toArray(new CompletableFuture[0])).thenApply(v -> endpointConnections.parallelStream().map(CompletableFuture::join).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private List<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> getConnections() {
        Collection<TarantoolServerAddress> addresses = this.getAddresses();
        if (addresses == null) {
            addresses = Collections.emptyList();
            logger.debug("The list of server addresses is not defined");
        }
        ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>> endpointConnections = new ArrayList<CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>>(addresses.size());
        block2: for (TarantoolServerAddress serverAddress : addresses) {
            List<TarantoolConnection> aliveConnections = this.getAliveConnections(serverAddress);
            if (aliveConnections.size() < this.config.getConnections()) {
                CompletionStage connectionFuture = this.establishConnectionsToEndpoint(serverAddress, this.config.getConnections() - aliveConnections.size()).thenApply(connections -> {
                    connections.addAll(aliveConnections);
                    return new AbstractMap.SimpleEntry<TarantoolServerAddress, List>(serverAddress, (List)connections);
                });
                endpointConnections.add((CompletableFuture<Map.Entry<TarantoolServerAddress, List<TarantoolConnection>>>)connectionFuture);
                continue;
            }
            if (aliveConnections.size() > this.config.getConnections()) {
                int count = this.config.getConnections() - aliveConnections.size();
                for (TarantoolConnection aliveConnection : aliveConnections) {
                    if (count-- <= 0) continue block2;
                    try {
                        logger.info("Closing connection to {}, connections size is greater than {}", (Object)aliveConnection.getRemoteAddress(), (Object)this.config.getConnections());
                        aliveConnection.close();
                    }
                    catch (Exception e) {
                        logger.info("Failed to close the connection: {}", (Object)e.getMessage());
                    }
                }
                continue;
            }
            endpointConnections.add(CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<TarantoolServerAddress, List<TarantoolConnection>>(serverAddress, aliveConnections)));
        }
        return endpointConnections;
    }

    private List<TarantoolConnection> getAliveConnections(TarantoolServerAddress serverAddress) {
        List connections = this.connectionRegistry.getOrDefault(serverAddress, Collections.emptyList());
        return connections.stream().filter(TarantoolConnection::isConnected).collect(Collectors.toList());
    }

    private CompletableFuture<List<TarantoolConnection>> establishConnectionsToEndpoint(TarantoolServerAddress serverAddress, int connectionCount) {
        List<CompletableFuture> connections = this.connectionFactory.multiConnection(serverAddress.getSocketAddress(), connectionCount, this.connectionListeners).stream().peek(cf -> cf.thenApply(conn -> {
            if (conn != null && conn.isConnected()) {
                logger.info("Connected to Tarantool server at {}", (Object)conn.getRemoteAddress());
                conn.addConnectionFailureListener((c, ex) -> {
                    this.connectionMode.set(ConnectionMode.PARTIAL);
                    try {
                        c.close();
                    }
                    catch (Exception e) {
                        logger.info("Failed to close the connection: {}", (Object)e.getMessage());
                    }
                });
                conn.addConnectionCloseListener(c -> logger.info("Disconnected from {}", (Object)c.getRemoteAddress()));
            }
            return conn;
        })).collect(Collectors.toList());
        return CompletableFuture.allOf(connections.toArray(new CompletableFuture[0])).thenApply(v -> connections.parallelStream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void closeOldConnections(Map<TarantoolServerAddress, List<TarantoolConnection>> registry) {
        registry.forEach((key, value) -> {
            if (!this.connectionRegistry.containsKey(key)) {
                value.forEach(AbstractTarantoolConnectionManager::closeConnection);
            }
        });
    }

    @Override
    public void close() {
        if (this.initPhaser.getRegisteredParties() > 0) {
            this.initPhaser.awaitAdvance(this.initPhaser.getPhase());
        }
        this.connectionRegistry.values().stream().flatMap(Collection::stream).forEach(AbstractTarantoolConnectionManager::closeConnection);
    }

    private static void closeConnection(TarantoolConnection connection) {
        try {
            connection.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close connection: {}", (Object)e.getMessage());
        }
    }
}

