/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.connection;

import io.netty.channel.Channel;
import io.tarantool.driver.TarantoolVersion;
import io.tarantool.driver.TarantoolVersionHolder;
import io.tarantool.driver.api.connection.TarantoolConnection;
import io.tarantool.driver.api.connection.TarantoolConnectionCloseListener;
import io.tarantool.driver.api.connection.TarantoolConnectionFailureListener;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolRequestMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.protocol.TarantoolRequest;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.msgpack.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolConnectionImpl
implements TarantoolConnection {
    protected final TarantoolVersionHolder versionHolder;
    protected final RequestFutureManager requestManager;
    protected final Channel channel;
    private final AtomicBoolean connected = new AtomicBoolean(true);
    private final List<TarantoolConnectionFailureListener> failureListeners = new ArrayList<TarantoolConnectionFailureListener>();
    private final List<TarantoolConnectionCloseListener> closeListeners = new ArrayList<TarantoolConnectionCloseListener>();
    private static final Logger logger = LoggerFactory.getLogger(TarantoolConnection.class);

    public TarantoolConnectionImpl(RequestFutureManager requestManager, TarantoolVersionHolder versionHolder, Channel channel) {
        this.requestManager = requestManager;
        this.versionHolder = versionHolder;
        this.channel = channel;
        channel.closeFuture().addListener(f -> {
            if (this.connected.compareAndSet(true, false)) {
                for (TarantoolConnectionFailureListener listener : this.failureListeners) {
                    listener.onConnectionFailure(this, f.cause());
                }
            }
        });
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws TarantoolClientException {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public TarantoolVersion getVersion() throws TarantoolClientException {
        if (!this.isConnected()) {
            throw new TarantoolClientException("Not connected to Tarantool server");
        }
        return this.versionHolder.getVersion();
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public TarantoolRequestMetadata sendRequest(TarantoolRequest request) {
        if (!this.isConnected()) {
            throw new TarantoolClientException("Not connected to Tarantool server");
        }
        TarantoolRequestMetadata requestMetadata = this.requestManager.submitRequest(request);
        CompletableFuture<Value> requestFuture = requestMetadata.getFuture();
        this.channel.writeAndFlush((Object)request).addListener(f -> {
            if (!f.isSuccess()) {
                requestFuture.completeExceptionally(new RuntimeException("Failed to send the request to Tarantool server", f.cause()));
            } else {
                logger.trace("Request {} sent, status Success", (Object)request);
            }
        });
        return requestMetadata;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void addConnectionFailureListener(TarantoolConnectionFailureListener listener) {
        this.failureListeners.add(listener);
    }

    @Override
    public void addConnectionCloseListener(TarantoolConnectionCloseListener listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void close() {
        this.connected.set(false);
        for (TarantoolConnectionCloseListener listener : this.closeListeners) {
            listener.onConnectionClosed(this);
        }
        this.requestManager.close();
        this.channel.pipeline().close();
        this.channel.closeFuture().syncUninterruptibly();
    }
}

