/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.metadata;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.metadata.TarantoolIndexMetadata;
import io.tarantool.driver.api.metadata.TarantoolIndexMetadataResult;
import io.tarantool.driver.api.metadata.TarantoolMetadataContainer;
import io.tarantool.driver.api.metadata.TarantoolMetadataProvider;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadataResult;
import io.tarantool.driver.core.metadata.SpacesTarantoolMetadataContainer;
import io.tarantool.driver.core.metadata.TarantoolIndexMetadataConverter;
import io.tarantool.driver.core.metadata.VSpaceToTarantoolSpaceMetadataConverter;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class SpacesMetadataProvider
implements TarantoolMetadataProvider {
    static final String VSPACE_SELECT_CMD = "box.space._vspace:select";
    static final String VINDEX_SELECT_CMD = "box.space._vindex:select";
    private final TarantoolCallOperations client;
    private final VSpaceToTarantoolSpaceMetadataConverter spaceMetadataMapper;
    private final CallResultMapper<TarantoolResult<TarantoolSpaceMetadata>, SingleValueCallResult<TarantoolResult<TarantoolSpaceMetadata>>> spaceMetadataResultMapper;
    private final Supplier<CallResultMapper<TarantoolResult<TarantoolSpaceMetadata>, SingleValueCallResult<TarantoolResult<TarantoolSpaceMetadata>>>> spaceMetadataResultMapperSupplier;
    private final TarantoolIndexMetadataConverter indexMetadataMapper;
    private final CallResultMapper<TarantoolResult<TarantoolIndexMetadata>, SingleValueCallResult<TarantoolResult<TarantoolIndexMetadata>>> indexMetadataResultMapper;
    private final Supplier<CallResultMapper<TarantoolResult<TarantoolIndexMetadata>, SingleValueCallResult<TarantoolResult<TarantoolIndexMetadata>>>> indexMetadataResultMapperSupplier;

    public SpacesMetadataProvider(TarantoolCallOperations client, MessagePackMapper messagePackMapper) {
        this.client = client;
        this.spaceMetadataMapper = VSpaceToTarantoolSpaceMetadataConverter.getInstance();
        this.spaceMetadataResultMapper = client.getResultMapperFactoryFactory().singleValueTarantoolResultMapperFactory().withSingleValueArrayTarantoolResultConverter(this.spaceMetadataMapper, TarantoolSpaceMetadataResult.class);
        this.spaceMetadataResultMapperSupplier = () -> this.spaceMetadataResultMapper;
        this.indexMetadataMapper = new TarantoolIndexMetadataConverter(messagePackMapper);
        this.indexMetadataResultMapper = client.getResultMapperFactoryFactory().singleValueTarantoolResultMapperFactory().withSingleValueArrayTarantoolResultConverter(this.indexMetadataMapper, TarantoolIndexMetadataResult.class);
        this.indexMetadataResultMapperSupplier = () -> this.indexMetadataResultMapper;
    }

    @Override
    public CompletableFuture<TarantoolMetadataContainer> getMetadata() throws TarantoolClientException {
        CompletableFuture<TarantoolResult<TarantoolSpaceMetadata>> spaces = this.select(VSPACE_SELECT_CMD, this.spaceMetadataResultMapperSupplier, TarantoolSpaceMetadata.class);
        CompletableFuture<TarantoolResult<TarantoolIndexMetadata>> indexes = this.select(VINDEX_SELECT_CMD, this.indexMetadataResultMapperSupplier, TarantoolIndexMetadata.class);
        return spaces.thenCombine(indexes, SpacesTarantoolMetadataContainer::new);
    }

    private <T> CompletableFuture<TarantoolResult<T>> select(String selectCmd, Supplier<CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>>> resultMapperSupplier, Class<T> resultClass) throws TarantoolClientException {
        return this.client.call(selectCmd, resultMapperSupplier);
    }
}

