/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.core.proxy;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolCallOperations;
import io.tarantool.driver.api.space.options.Options;
import io.tarantool.driver.api.space.options.Self;
import io.tarantool.driver.core.proxy.BuilderOptions;
import io.tarantool.driver.core.proxy.ProxyOperation;
import io.tarantool.driver.core.proxy.enums.ProxyOperationArgument;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

abstract class AbstractProxyOperation<T>
implements ProxyOperation<T> {
    protected final TarantoolCallOperations client;
    protected final String functionName;
    protected final Collection<?> arguments;
    private final Supplier<MessagePackObjectMapper> argumentsMapperSupplier;
    private final Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier;

    AbstractProxyOperation(TarantoolCallOperations client, String functionName, Collection<?> arguments, Supplier<MessagePackObjectMapper> argumentsMapperSupplier, Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) {
        this.client = client;
        this.argumentsMapperSupplier = argumentsMapperSupplier;
        this.arguments = arguments;
        this.functionName = functionName;
        this.resultMapperSupplier = resultMapperSupplier;
    }

    public TarantoolCallOperations getClient() {
        return this.client;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Collection<?> getArguments() {
        return this.arguments;
    }

    public Supplier<MessagePackObjectMapper> getArgumentsMapperSupplier() {
        return this.argumentsMapperSupplier;
    }

    public Supplier<CallResultMapper<T, SingleValueCallResult<T>>> getResultMapperSupplier() {
        return this.resultMapperSupplier;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.client.callForSingleResult(this.functionName, this.arguments, this.argumentsMapperSupplier, this.resultMapperSupplier);
    }

    static abstract class GenericOperationsBuilder<T, O extends Options, B extends GenericOperationsBuilder<T, O, B>>
    implements BuilderOptions,
    Self<B> {
        protected TarantoolCallOperations client;
        protected String functionName;
        protected EnumMap<ProxyOperationArgument, Object> arguments = new EnumMap(ProxyOperationArgument.class);
        protected Supplier<MessagePackObjectMapper> argumentsMapperSupplier;
        protected Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier;

        GenericOperationsBuilder() {
        }

        @Override
        public void addArgument(ProxyOperationArgument optionName, Object option) {
            this.arguments.put(optionName, option);
        }

        public B withClient(TarantoolCallOperations client) {
            this.client = client;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withSpaceName(String spaceName) {
            this.addArgument(ProxyOperationArgument.SPACE_NAME, spaceName);
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withFunctionName(String functionName) {
            this.functionName = functionName;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withArgumentsMapperSupplier(Supplier<MessagePackObjectMapper> argumentsMapperSupplier) {
            this.argumentsMapperSupplier = argumentsMapperSupplier;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withResultMapperSupplier(Supplier<CallResultMapper<T, SingleValueCallResult<T>>> resultMapperSupplier) {
            this.resultMapperSupplier = resultMapperSupplier;
            return (B)((GenericOperationsBuilder)this.self());
        }

        public B withOptions(O options) {
            this.addArgument(ProxyOperationArgument.OPTIONS, options.asMap());
            return (B)((GenericOperationsBuilder)this.self());
        }
    }
}

