/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.handlers;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import io.tarantool.driver.core.RequestFutureManager;
import io.tarantool.driver.core.TarantoolRequestMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.protocol.TarantoolRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolRequestHandler
extends ChannelOutboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(TarantoolRequestHandler.class);
    private final RequestFutureManager futureManager;

    public TarantoolRequestHandler(RequestFutureManager futureManager) {
        this.futureManager = futureManager;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        TarantoolRequest request = (TarantoolRequest)msg;
        ctx.writeAndFlush((Object)request, promise).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (!channelFuture.isSuccess()) {
                TarantoolRequestMetadata requestMeta = this.futureManager.getRequest(request.getHeader().getSync());
                if (requestMeta != null) {
                    requestMeta.getFuture().completeExceptionally(new TarantoolClientException(channelFuture.cause()));
                } else {
                    this.log.info("Received an error for {} but it is already timed out: {}", (Object)request, (Object)channelFuture.cause());
                }
            }
        }));
    }
}

