/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.api.MessagePackMapperBuilder;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.InterfaceParameterTypeNotFoundException;
import io.tarantool.driver.mappers.MapperReflectionUtils;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapperException;
import io.tarantool.driver.mappers.MessagePackValueMapperException;
import io.tarantool.driver.mappers.converters.ConverterWrapper;
import io.tarantool.driver.mappers.converters.ObjectConverter;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.object.DefaultCollectionToArrayValueConverter;
import io.tarantool.driver.mappers.converters.object.DefaultListToArrayValueConverter;
import io.tarantool.driver.mappers.converters.object.DefaultMapToMapValueConverter;
import io.tarantool.driver.mappers.converters.value.defaults.DefaultArrayValueToListConverter;
import io.tarantool.driver.mappers.converters.value.defaults.DefaultMapValueToMapConverter;
import io.tarantool.driver.mappers.converters.value.defaults.DefaultNullToNilValueConverter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.msgpack.value.NilValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public class DefaultMessagePackMapper
implements MessagePackMapper {
    private static final long serialVersionUID = 20220418L;
    private final Map<ValueType, List<ConverterWrapper<ValueConverter<? extends Value, ?>>>> valueConverters;
    private final Map<String, List<ConverterWrapper<ObjectConverter<?, ? extends Value>>>> objectConverters;
    private final ObjectConverter<Object, NilValue> nilConverter = new DefaultNullToNilValueConverter();

    public DefaultMessagePackMapper() {
        this.valueConverters = new HashMap();
        this.objectConverters = new HashMap();
    }

    public DefaultMessagePackMapper(DefaultMessagePackMapper mapper) {
        this.valueConverters = mapper.valueConverters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
        this.objectConverters = mapper.objectConverters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
    }

    @Override
    public <V extends Value, O> O fromValue(V v) {
        Optional<ValueConverter<V, O>> converter = this.getValueConverter(v, v.getValueType());
        if (!converter.isPresent()) {
            throw new MessagePackValueMapperException("ValueConverter for type %s is not found", v.getClass());
        }
        return converter.get().fromValue(v);
    }

    private <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverter(V v, ValueType valueType) {
        List wrappers = this.valueConverters.getOrDefault(valueType, Collections.emptyList());
        for (int i = 0; i < wrappers.size(); ++i) {
            ValueConverter converter = (ValueConverter)((ConverterWrapper)wrappers.get(i)).getConverter();
            if (!converter.canConvertValue(v)) continue;
            return Optional.of(converter);
        }
        return Optional.empty();
    }

    @Override
    public <V extends Value, O> O fromValue(V v, Class<O> targetClass) {
        Optional<ValueConverter<V, O>> converter = this.getValueConverter(v, v.getValueType(), targetClass);
        if (!converter.isPresent()) {
            throw new MessagePackValueMapperException("ValueConverter for type %s and target class %s is not found", v.getClass(), targetClass);
        }
        return converter.get().fromValue(v);
    }

    private <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverter(V v, ValueType valueType, Class<O> targetClass) {
        List wrappers = this.valueConverters.getOrDefault(valueType, Collections.emptyList());
        for (int i = 0; i < wrappers.size(); ++i) {
            ValueConverter converter;
            ConverterWrapper wrapper = (ConverterWrapper)wrappers.get(i);
            if (!this.checkConverterByTargetType(wrapper.getTargetClass(), targetClass) || !(converter = (ValueConverter)wrapper.getConverter()).canConvertValue(v)) continue;
            return Optional.of(converter);
        }
        return Optional.empty();
    }

    private boolean checkConverterByTargetType(Class<?> targetClassOfConverter, Class<?> targetClass) {
        return targetClassOfConverter.isAssignableFrom(targetClass);
    }

    private <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverterByTargetType(ValueType valueType, Class<? extends O> targetClass) {
        List wrappers = this.valueConverters.getOrDefault(valueType, Collections.emptyList());
        for (int i = 0; i < wrappers.size(); ++i) {
            ConverterWrapper wrapper = (ConverterWrapper)wrappers.get(i);
            if (!this.checkConverterByTargetType(wrapper.getTargetClass(), targetClass)) continue;
            return Optional.of((ValueConverter)wrapper.getConverter());
        }
        return Optional.empty();
    }

    @Override
    public <V extends Value, O> Optional<ValueConverter<V, O>> getValueConverter(ValueType valueType, Class<? extends O> targetClass) {
        return this.getValueConverterByTargetType(valueType, targetClass);
    }

    public <V extends Value, O> void registerValueConverter(ValueType valueType, ValueConverter<V, ? extends O> converter) {
        try {
            Class objectClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ValueConverter.class, 1);
            this.registerValueConverter(valueType, objectClass, converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerValueConverter(valueClass, objectClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerValueConverter(ValueType valueType, Class<? extends O> objectClass, ValueConverter<V, ? extends O> converter) {
        List converters = this.valueConverters.computeIfAbsent(valueType, k -> new ArrayList());
        converters.add(0, new ConverterWrapper<ValueConverter<V, ? extends O>>(converter, objectClass));
    }

    @Override
    public <V extends Value, O> void registerValueConverterWithoutTargetClass(ValueType valueType, ValueConverter<V, ? extends O> converter) {
        List converters = this.valueConverters.computeIfAbsent(valueType, k -> new ArrayList());
        converters.add(0, new ConverterWrapper<ValueConverter<V, ? extends O>>(converter, Object.class));
    }

    @Override
    public <V extends Value, O> V toValue(O o) {
        ObjectConverter<O, V> converter = this.getObjectConverter(o);
        return converter.toValue(o);
    }

    private <V extends Value, O> ObjectConverter<O, V> getObjectConverter(O o) {
        if (o == null) {
            return this.nilConverter;
        }
        Optional<ObjectConverter<O, V>> converter = this.findObjectConverter(o, o.getClass());
        if (!converter.isPresent()) {
            throw new MessagePackObjectMapperException("ObjectConverter for type %s is not found", o.getClass());
        }
        return converter.get();
    }

    private <V extends Value, O> Optional<ObjectConverter<O, V>> getObjectConverter(O o, String typeName) {
        List wrappers = this.objectConverters.getOrDefault(typeName, Collections.emptyList());
        for (int i = 0; i < wrappers.size(); ++i) {
            ObjectConverter converter = (ObjectConverter)((ConverterWrapper)wrappers.get(i)).getConverter();
            if (!converter.canConvertObject(o)) continue;
            return Optional.of(converter);
        }
        return Optional.empty();
    }

    private <V extends Value, O> Optional<ObjectConverter<O, V>> findObjectConverter(O o, Class<?> objectClass) {
        Optional<ObjectConverter<O, V>> converter = this.getObjectConverter(o, objectClass.getTypeName());
        if (!converter.isPresent() && objectClass.getSuperclass() != null) {
            converter = this.findObjectConverter(o, objectClass.getSuperclass());
        }
        if (!converter.isPresent()) {
            Class<?> iface;
            Class<?>[] classArray = objectClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && !(converter = this.findObjectConverter(o, iface = classArray[i])).isPresent(); ++i) {
            }
        }
        return converter;
    }

    private <V extends Value, O> Optional<ObjectConverter<O, V>> getObjectConverterByTargetType(String typeName, Class<? extends V> valueClass) {
        List wrappers = this.objectConverters.getOrDefault(typeName, Collections.emptyList());
        for (int i = 0; i < wrappers.size(); ++i) {
            ConverterWrapper wrapper = (ConverterWrapper)wrappers.get(i);
            if (!this.checkConverterByTargetType(wrapper.getTargetClass(), valueClass)) continue;
            return Optional.of((ObjectConverter)wrapper.getConverter());
        }
        return Optional.empty();
    }

    private <V extends Value, O> Optional<ObjectConverter<O, V>> findObjectConverter(Class<?> objectClass, Class<? extends V> valueClass) {
        Optional<ObjectConverter<O, Object>> converter = this.getObjectConverterByTargetType(objectClass.getTypeName(), valueClass);
        if (!converter.isPresent() && objectClass.getSuperclass() != null) {
            converter = this.findObjectConverter(objectClass.getSuperclass(), valueClass);
        }
        if (!converter.isPresent()) {
            Class<?> iface;
            Class<?>[] classArray = objectClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && !(converter = this.findObjectConverter(iface = classArray[i], valueClass)).isPresent(); ++i) {
            }
        }
        return converter;
    }

    @Override
    public <V extends Value, O> Optional<ObjectConverter<O, V>> getObjectConverter(Class<? extends O> objectClass, Class<? extends V> valueClass) {
        return this.findObjectConverter(objectClass, valueClass);
    }

    public <V extends Value, O> void registerObjectConverter(ObjectConverter<O, V> converter) {
        try {
            this.registerObjectConverter(MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 0), converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    public <V extends Value, O> void registerObjectConverter(Class<? extends O> objectClass, ObjectConverter<O, V> converter) {
        try {
            Class valueClass = MapperReflectionUtils.getInterfaceParameterClass(converter, ObjectConverter.class, 1);
            this.registerObjectConverter(objectClass, valueClass, converter);
        }
        catch (InterfaceParameterClassNotFoundException | InterfaceParameterTypeNotFoundException e) {
            throw new TarantoolClientException("Failed to determine the target parameter type of the generic interface, try to use the method registerObjectConverter(objectClass, valueClass, converter) for registering the converter");
        }
    }

    @Override
    public <V extends Value, O> void registerObjectConverter(Class<? extends O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
        List converters = this.objectConverters.computeIfAbsent(objectClass.getTypeName(), k -> new ArrayList());
        converters.add(0, new ConverterWrapper<ObjectConverter<O, V>>(converter, valueClass));
    }

    @Override
    public MessagePackMapper copy() {
        return new DefaultMessagePackMapper(this);
    }

    public static class Builder
    implements MessagePackMapperBuilder {
        private final DefaultMessagePackMapper mapper;

        public Builder() {
            this.mapper = new DefaultMessagePackMapper();
        }

        public Builder(DefaultMessagePackMapper mapper) {
            this.mapper = new DefaultMessagePackMapper(mapper);
        }

        @Override
        public Builder withDefaultMapValueConverter() {
            this.mapper.registerValueConverter(ValueType.MAP, new DefaultMapValueToMapConverter(this.mapper));
            return this;
        }

        @Override
        public Builder withDefaultMapObjectConverter() {
            DefaultMapToMapValueConverter converter = new DefaultMapToMapValueConverter(this.mapper);
            this.mapper.registerObjectConverter(converter);
            Class<HashMap> cls = HashMap.class;
            this.mapper.registerObjectConverter(cls, converter);
            return this;
        }

        @Override
        public Builder withDefaultArrayValueConverter() {
            this.mapper.registerValueConverter(ValueType.ARRAY, new DefaultArrayValueToListConverter(this.mapper));
            return this;
        }

        @Override
        public Builder withDefaultCollectionObjectConverter() {
            DefaultCollectionToArrayValueConverter converter = new DefaultCollectionToArrayValueConverter(this.mapper);
            this.mapper.registerObjectConverter(converter);
            this.mapper.registerObjectConverter(Collection.class, converter);
            this.mapper.registerObjectConverter(AbstractCollection.class, converter);
            return this;
        }

        @Override
        public Builder withDefaultListObjectConverter() {
            DefaultListToArrayValueConverter converter = new DefaultListToArrayValueConverter(this.mapper);
            this.mapper.registerObjectConverter(converter);
            Class<ArrayList> cls = ArrayList.class;
            this.mapper.registerObjectConverter(cls, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withValueConverter(ValueType valueType, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueType, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withValueConverter(ValueType valueType, Class<O> objectClass, ValueConverter<V, O> converter) {
            this.mapper.registerValueConverter(valueType, objectClass, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, converter);
            return this;
        }

        @Override
        public <V extends Value, O> Builder withObjectConverter(Class<O> objectClass, Class<V> valueClass, ObjectConverter<O, V> converter) {
            this.mapper.registerObjectConverter(objectClass, valueClass, converter);
            return this;
        }

        @Override
        public DefaultMessagePackMapper build() {
            return this.mapper;
        }
    }
}

