/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers;

import io.tarantool.driver.mappers.InterfaceParameterClassNotFoundException;
import io.tarantool.driver.mappers.InterfaceParameterTypeNotFoundException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.stream.Stream;

public final class MapperReflectionUtils {
    private MapperReflectionUtils() {
    }

    public static <T> Class<T> getConverterTargetType(Object converter) throws InterfaceParameterClassNotFoundException {
        Type[] genericInterfaces = MapperReflectionUtils.getGenericInterfaces(converter);
        if (genericInterfaces.length < 1) {
            throw new RuntimeException(String.format("The passed converter object of type %s does not extend any generic interface", converter.getClass()));
        }
        if (genericInterfaces.length > 1) {
            throw new RuntimeException(String.format("The passed converter object of type %s has more than one generic interfaces, unable to determine the target", converter.getClass()));
        }
        if (!(genericInterfaces[0] instanceof ParameterizedType)) {
            throw new RuntimeException(String.format("The passed converter object of type %s interface type is not a parameterized type", converter.getClass()));
        }
        try {
            return Class.forName(((ParameterizedType)genericInterfaces[0]).getActualTypeArguments()[1].getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new InterfaceParameterClassNotFoundException(e);
        }
    }

    static <T> Class<T> getInterfaceParameterClass(Object converter, Class<?> interfaceClass, int parameterTypePosition) throws InterfaceParameterTypeNotFoundException, InterfaceParameterClassNotFoundException {
        try {
            return Class.forName(MapperReflectionUtils.getInterfaceParameterType(converter, interfaceClass, parameterTypePosition).getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new InterfaceParameterClassNotFoundException(e);
        }
    }

    private static Type getInterfaceParameterType(Object converter, Class<?> interfaceClass, int parameterTypePosition) throws InterfaceParameterTypeNotFoundException, InterfaceParameterClassNotFoundException {
        Type[] genericInterfaces = MapperReflectionUtils.getGenericInterfaces(converter);
        try {
            for (Type iface : genericInterfaces) {
                ParameterizedType parameterizedType;
                if (!(iface instanceof ParameterizedType) || !Class.forName((parameterizedType = (ParameterizedType)iface).getRawType().getTypeName()).isAssignableFrom(interfaceClass)) continue;
                return MapperReflectionUtils.getParameterType(parameterizedType, parameterTypePosition);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InterfaceParameterClassNotFoundException(e);
        }
        throw new InterfaceParameterTypeNotFoundException("Unable to determine the generic parameter type on position %d for %s. Either the class does not implement any generic interfaces or the parametrized types cannot be determined due to type erasure", parameterTypePosition, converter.getClass());
    }

    private static Type[] getGenericInterfaces(Object converter) {
        Type[] genericInterfaces = converter.getClass().getGenericInterfaces();
        if (genericInterfaces == null) {
            throw new RuntimeException(String.format("Unable to determine the generic interfaces for %s", converter.getClass()));
        }
        return genericInterfaces;
    }

    private static Type getParameterType(ParameterizedType parameterizedType, int parameterTypePosition) {
        Type[] typeParams = parameterizedType.getActualTypeArguments();
        if (typeParams == null || typeParams.length != 2) {
            throw new RuntimeException(String.format("Type %s does not have 2 type parameters", parameterizedType));
        }
        if (typeParams[parameterTypePosition] instanceof ParameterizedType && Stream.of(((ParameterizedType)typeParams[parameterTypePosition]).getActualTypeArguments()).allMatch(t -> t instanceof WildcardType)) {
            return ((ParameterizedType)typeParams[parameterTypePosition]).getRawType();
        }
        return typeParams[parameterTypePosition];
    }
}

