/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.object;

import io.tarantool.driver.mappers.converters.Interval;
import io.tarantool.driver.mappers.converters.ObjectConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.value.ExtensionValue;
import org.msgpack.value.ValueFactory;

public class DefaultIntervalToExtensionValueConverter
implements ObjectConverter<Interval, ExtensionValue> {
    private static final long serialVersionUID = 20221025L;
    public static final byte EXT_TYPE = 6;
    public static final int FIELD_ADJUST = 8;

    private byte[] toBytes(Interval value) {
        byte[] byArray;
        block12: {
            int fieldsCount = 0;
            List<Long> fields = Arrays.asList(value.getYear(), value.getMonth(), value.getWeek(), value.getDay(), value.getHour(), value.getMin(), value.getSec(), value.getNsec());
            for (long fieldValue : fields) {
                if (fieldValue == 0L) continue;
                ++fieldsCount;
            }
            int adjust = value.getAdjust().ordinal();
            if (adjust != 0) {
                ++fieldsCount;
            }
            MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
            try {
                packer.packInt(fieldsCount);
                for (int i = 0; i < fields.size(); ++i) {
                    DefaultIntervalToExtensionValueConverter.packField(packer, i, fields.get(i));
                }
                if (adjust != 0) {
                    packer.packInt(8);
                    packer.packLong((long)adjust);
                }
                byArray = packer.toByteArray();
                if (packer == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (packer != null) {
                        try {
                            packer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            packer.close();
        }
        return byArray;
    }

    private static void packField(MessageBufferPacker packer, int fieldId, long fieldValue) throws IOException {
        if (fieldValue != 0L) {
            packer.packInt(fieldId);
            packer.packLong(fieldValue);
        }
    }

    @Override
    public ExtensionValue toValue(Interval object) {
        return ValueFactory.newExtension((byte)6, (byte[])this.toBytes(object));
    }
}

