/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.converters.value.defaults;

import io.tarantool.driver.mappers.converters.Adjust;
import io.tarantool.driver.mappers.converters.Interval;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.io.IOException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ExtensionValue;

public class DefaultExtensionValueToIntervalConverter
implements ValueConverter<ExtensionValue, Interval> {
    public static final byte EXT_TYPE = 6;
    public static final int FIELD_YEAR = 0;
    public static final int FIELD_MONTH = 1;
    public static final int FIELD_WEEK = 2;
    public static final int FIELD_DAY = 3;
    public static final int FIELD_HOUR = 4;
    public static final int FIELD_MIN = 5;
    public static final int FIELD_SEC = 6;
    public static final int FIELD_NSEC = 7;
    public static final int FIELD_ADJUST = 8;
    public static final int NONE_ADJUST = 0;
    public static final int EXCESS_ADJUST = 1;
    public static final int LAST_ADJUST = 2;

    private Interval fromBytes(byte[] bytes) {
        Interval interval = new Interval();
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);){
            int fieldsCount = unpacker.unpackInt();
            block23: for (int i = 0; i < fieldsCount; ++i) {
                int type = unpacker.unpackInt();
                block3 : switch (type) {
                    case 0: {
                        interval.setYear(unpacker.unpackLong());
                        continue block23;
                    }
                    case 1: {
                        interval.setMonth(unpacker.unpackLong());
                        continue block23;
                    }
                    case 2: {
                        interval.setWeek(unpacker.unpackLong());
                        continue block23;
                    }
                    case 3: {
                        interval.setDay(unpacker.unpackLong());
                        continue block23;
                    }
                    case 4: {
                        interval.setHour(unpacker.unpackLong());
                        continue block23;
                    }
                    case 5: {
                        interval.setMin(unpacker.unpackLong());
                        continue block23;
                    }
                    case 6: {
                        interval.setSec(unpacker.unpackLong());
                        continue block23;
                    }
                    case 7: {
                        interval.setNsec(unpacker.unpackLong());
                        continue block23;
                    }
                    case 8: {
                        long adjust = unpacker.unpackLong();
                        switch ((int)adjust) {
                            case 0: {
                                interval.setAdjust(Adjust.NoneAdjust);
                                break block3;
                            }
                            case 1: {
                                interval.setAdjust(Adjust.ExcessAdjust);
                                break block3;
                            }
                            case 2: {
                                interval.setAdjust(Adjust.LastAdjust);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return interval;
    }

    @Override
    public Interval fromValue(ExtensionValue value) {
        return this.fromBytes(value.getData());
    }

    @Override
    public boolean canConvertValue(ExtensionValue value) {
        return value.getType() == 6;
    }
}

