/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.mappers.factories;

import io.tarantool.driver.api.MultiValueCallResult;
import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.exceptions.TarantoolClientException;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.DefaultMultiValueResultMapper;
import io.tarantool.driver.mappers.DefaultSingleValueResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.TarantoolTupleResultMapperFactory;
import io.tarantool.driver.mappers.TarantoolTupleResultMapperFactoryImpl;
import io.tarantool.driver.mappers.converters.ValueConverter;
import io.tarantool.driver.mappers.converters.ValueConverterWithInputTypeWrapper;
import io.tarantool.driver.mappers.converters.value.ArrayValueToMultiValueListConverter;
import io.tarantool.driver.mappers.factories.ArrayValueToTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.factories.ArrayValueToTarantoolTupleResultMapperFactory;
import io.tarantool.driver.mappers.factories.MultiValueResultMapperFactory;
import io.tarantool.driver.mappers.factories.MultiValueWithTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.factories.MultiValueWithTarantoolTupleResultMapperFactory;
import io.tarantool.driver.mappers.factories.ResultMapperFactoryFactory;
import io.tarantool.driver.mappers.factories.RowsMetadataToTarantoolTupleResultMapperFactory;
import io.tarantool.driver.mappers.factories.SingleValueResultMapperFactory;
import io.tarantool.driver.mappers.factories.SingleValueWithTarantoolResultMapperFactory;
import io.tarantool.driver.mappers.factories.SingleValueWithTarantoolTupleResultMapperFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public final class ResultMapperFactoryFactoryImpl
implements ResultMapperFactoryFactory {
    @Override
    public ArrayValueToTarantoolTupleResultMapperFactory arrayTupleResultMapperFactory() {
        return new ArrayValueToTarantoolTupleResultMapperFactory();
    }

    @Override
    public TarantoolTupleResultMapperFactory getTarantoolTupleResultMapperFactory() {
        return TarantoolTupleResultMapperFactoryImpl.getInstance();
    }

    @Override
    public RowsMetadataToTarantoolTupleResultMapperFactory rowsMetadataTupleResultMapperFactory() {
        return new RowsMetadataToTarantoolTupleResultMapperFactory();
    }

    @Override
    public SingleValueWithTarantoolTupleResultMapperFactory singleValueTupleResultMapperFactory() {
        return new SingleValueWithTarantoolTupleResultMapperFactory();
    }

    @Override
    public MultiValueWithTarantoolTupleResultMapperFactory multiValueTupleResultMapperFactory() {
        return new MultiValueWithTarantoolTupleResultMapperFactory();
    }

    @Override
    public <T> ArrayValueToTarantoolResultMapperFactory<T> rowsMetadataStructureResultMapperFactory() {
        return new ArrayValueToTarantoolResultMapperFactory();
    }

    @Override
    public <T> SingleValueResultMapperFactory<T> singleValueResultMapperFactory() {
        return new SingleValueResultMapperFactory();
    }

    @Override
    public <T> SingleValueWithTarantoolResultMapperFactory<T> singleValueTarantoolResultMapperFactory() {
        return new SingleValueWithTarantoolResultMapperFactory();
    }

    @Override
    public <T, R extends List<T>> MultiValueResultMapperFactory<T, R> multiValueResultMapperFactory() {
        return new MultiValueResultMapperFactory();
    }

    @Override
    public <T> MultiValueWithTarantoolResultMapperFactory<T> multiValueTarantoolResultMapperFactory() {
        return new MultiValueWithTarantoolResultMapperFactory();
    }

    public <T> CallResultMapper<T, SingleValueCallResult<T>> getSingleValueResultMapper(ValueConverter<Value, T> valueConverter) {
        return this.singleValueResultMapperFactory().withSingleValueResultConverter(valueConverter, SingleValueCallResult.class);
    }

    public <T, R extends List<T>> CallResultMapper<R, MultiValueCallResult<T, R>> getMultiValueResultMapper(Supplier<R> containerSupplier, ValueConverter<Value, T> valueConverter) {
        return this.multiValueResultMapperFactory().withMultiValueResultConverter(new ArrayValueToMultiValueListConverter<T, R, Value>(valueConverter, containerSupplier), MultiValueCallResult.class);
    }

    public <T> CallResultMapper<TarantoolResult<T>, SingleValueCallResult<TarantoolResult<T>>> getTarantoolResultMapper(MessagePackMapper mapper, Class<T> tupleClass) {
        return this.singleValueTarantoolResultMapperFactory().withSingleValueArrayTarantoolResultConverter(this.getConverter(mapper, ValueType.ARRAY, tupleClass));
    }

    public <T, R extends List<T>> CallResultMapper<R, MultiValueCallResult<T, R>> getDefaultMultiValueMapper(MessagePackMapper mapper, Class<T> tupleClass) {
        return new DefaultMultiValueResultMapper(mapper, tupleClass);
    }

    public <T> CallResultMapper<T, SingleValueCallResult<T>> getDefaultSingleValueMapper(MessagePackValueMapper mapper, Class<T> tupleClass) {
        return new DefaultSingleValueResultMapper<T>(mapper, tupleClass);
    }

    private <V extends Value, T> ValueConverter<V, T> getConverter(MessagePackMapper mapper, ValueType valueType, Class<T> tupleClass) {
        Optional converter = mapper.getValueConverter(valueType, tupleClass);
        if (!converter.isPresent()) {
            throw new TarantoolClientException("No converter for value type %s and type %s is present", valueType, tupleClass);
        }
        return converter.get();
    }

    @Override
    public Builder createMapper(MessagePackMapper messagePackMapper) {
        return this.createMapper(messagePackMapper, null);
    }

    @Override
    public Builder createMapper(MessagePackMapper messagePackMapper, TarantoolSpaceMetadata spaceMetadata) {
        return new Builder(messagePackMapper, spaceMetadata);
    }

    private class Builder
    implements ResultMapperFactoryFactory.Builder {
        private final List<ValueConverterWithInputTypeWrapper<Object>> mappers = new ArrayList<ValueConverterWithInputTypeWrapper<Object>>();
        private final MessagePackMapper clientMapper;
        private final TarantoolSpaceMetadata spaceMetadata;

        Builder(MessagePackMapper messagePackMapper, TarantoolSpaceMetadata spaceMetadata) {
            this.clientMapper = messagePackMapper;
            this.spaceMetadata = spaceMetadata;
        }

        @Override
        public ResultMapperFactoryFactory.Builder withSingleValueConverter() {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.singleValueResultMapperFactory().getSingleValueResultConverter(this.clientMapper));
            return this;
        }

        @Override
        public Builder withSingleValueConverter(MessagePackValueMapper messagePackMapper) {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.singleValueResultMapperFactory().getSingleValueResultConverter(messagePackMapper));
            return this;
        }

        @Override
        public Builder withArrayValueToTarantoolTupleResultConverter(MessagePackMapper messagePackMapper) {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.arrayTupleResultMapperFactory().getArrayValueToTarantoolTupleResultConverter(messagePackMapper, this.spaceMetadata));
            return this;
        }

        @Override
        public ResultMapperFactoryFactory.Builder withArrayValueToTarantoolTupleResultConverter() {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.arrayTupleResultMapperFactory().getArrayValueToTarantoolTupleResultConverter(this.clientMapper, this.spaceMetadata));
            return this;
        }

        @Override
        public Builder withRowsMetadataToTarantoolTupleResultConverter(MessagePackMapper messagePackMapper) {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.rowsMetadataTupleResultMapperFactory().getRowsMetadataToTarantoolTupleResultConverter(messagePackMapper, this.spaceMetadata));
            return this;
        }

        @Override
        public ResultMapperFactoryFactory.Builder withRowsMetadataToTarantoolTupleResultConverter() {
            this.mappers.add(ResultMapperFactoryFactoryImpl.this.rowsMetadataTupleResultMapperFactory().getRowsMetadataToTarantoolTupleResultConverter(this.clientMapper, this.spaceMetadata));
            return this;
        }

        @Override
        public CallResultMapper buildCallResultMapper() {
            return new CallResultMapper((MessagePackValueMapper)this.clientMapper.copy(), this.mappers);
        }

        @Override
        public CallResultMapper buildCallResultMapper(MessagePackMapper valueMapper) {
            return new CallResultMapper((MessagePackValueMapper)valueMapper, this.mappers);
        }

        @Override
        public <T> CallResultMapper<T, SingleValueCallResult<T>> buildSingleValueResultMapper(MessagePackValueMapper valueMapper, Class<T> classResult) {
            return ResultMapperFactoryFactoryImpl.this.getDefaultSingleValueMapper(valueMapper, classResult);
        }
    }
}

