/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.exceptions.TarantoolDecoderException;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolHeader;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestSignature;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessagePacker;

public abstract class TarantoolRequest {
    private static final AtomicLong syncId = new AtomicLong(0L);
    private static final Supplier<Long> syncIdSupplier = () -> syncId.updateAndGet(n -> n >= Long.MAX_VALUE ? 1L : n + 1L);
    private final TarantoolHeader header;
    private final TarantoolRequestBody body;
    private final Optional<TarantoolRequestSignature> signature;

    public TarantoolRequest(TarantoolRequestType type, TarantoolRequestBody body, TarantoolRequestSignature signature) {
        this.header = new TarantoolHeader(syncIdSupplier.get(), type.getCode());
        this.body = body;
        this.signature = Optional.ofNullable(signature);
    }

    public TarantoolHeader getHeader() {
        return this.header;
    }

    public TarantoolRequestBody getBody() {
        return this.body;
    }

    public Optional<TarantoolRequestSignature> getSignature() {
        return this.signature;
    }

    public void toMessagePack(MessagePacker packer, MessagePackObjectMapper mapper) throws TarantoolDecoderException {
        try {
            packer.packValue(this.header.toMessagePackValue(mapper));
            packer.packValue(this.body.toMessagePackValue(mapper));
        }
        catch (IOException | MessagePackException e) {
            throw new TarantoolDecoderException(this.header, (Exception)e);
        }
    }

    public String toString() {
        return !this.signature.isPresent() ? String.format("request id: %d", this.header.getSync()) : String.format("request signature: %s", this.signature.get());
    }

    protected static abstract class Builder<B extends Builder<B>> {
        protected TarantoolRequestSignature signature;

        protected Builder() {
        }

        protected abstract B self();

        public B withSignature(TarantoolRequestSignature signature) {
            this.signature = signature;
            return this.self();
        }
    }
}

