/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.msgpack.value.Value;

public final class TarantoolRequestSignature {
    private List<String> components = new ArrayList<String>();
    private int hashCode = 1;

    public TarantoolRequestSignature() {
    }

    private TarantoolRequestSignature(Object[] initialComponents) {
        for (Object component : initialComponents) {
            if (component == null) continue;
            String componentValue = component instanceof String ? (String)component : component.getClass().getName();
            this.components.add(componentValue);
            this.hashCode = 31 * this.hashCode + Objects.hashCode(componentValue);
        }
    }

    public TarantoolRequestSignature addComponent(Object component) {
        if (component != null) {
            String componentValue = component instanceof String ? (String)component : component.getClass().getName();
            this.components.add(componentValue);
            this.hashCode = 31 * this.hashCode + Objects.hashCode(componentValue);
        }
        return this;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof TarantoolRequestSignature && Objects.equals(this.components, ((TarantoolRequestSignature)other).components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (String component : this.components) {
            sb.append(String.valueOf(component)).append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier) {
        Object[] components = new Object[arguments.size() + 2];
        int i = 0;
        components[i++] = functionName;
        for (Object argument : arguments) {
            components[i++] = argument.getClass().getName();
        }
        components[i++] = Integer.toHexString(argumentsMapperSupplier.hashCode());
        return new TarantoolRequestSignature(components);
    }

    public static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Class<?> resultClass) {
        return TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier).addComponent(resultClass.getName());
    }

    public static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, ValueConverter<Value, ?> valueConverter) {
        return TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier).addComponent(Integer.toHexString(valueConverter.hashCode()));
    }

    public static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<?> resultContainerSupplier, ValueConverter<Value, ?> valueConverter) {
        return TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier).addComponent(Integer.toHexString(resultContainerSupplier.hashCode())).addComponent(Integer.toHexString(valueConverter.hashCode()));
    }

    public static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<?> resultContainerSupplier, Class<?> resultClass) {
        return TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier).addComponent(Integer.toHexString(resultContainerSupplier.hashCode())).addComponent(resultClass.getName());
    }

    public static TarantoolRequestSignature create(String functionName, Collection<?> arguments, Supplier<? extends MessagePackObjectMapper> argumentsMapperSupplier, Supplier<? extends MessagePackValueMapper> resultMapperSupplier) {
        return TarantoolRequestSignature.create(functionName, arguments, argumentsMapperSupplier).addComponent(Integer.toHexString(resultMapperSupplier.hashCode()));
    }
}

