/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestSignature;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TarantoolDeleteRequest
extends TarantoolRequest {
    private TarantoolDeleteRequest(TarantoolRequestBody body, TarantoolRequestSignature signature) {
        super(TarantoolRequestType.IPROTO_DELETE, body, signature);
    }

    public static class Builder
    extends TarantoolRequest.Builder<Builder> {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(3, 1.0f);

        @Override
        protected Builder self() {
            return this;
        }

        public Builder withSpaceId(int spaceId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode(), spaceId);
            return this;
        }

        public Builder withIndexId(int indexId) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode(), indexId);
            return this;
        }

        public Builder withKeyValues(List<?> keyValues) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_KEY.getCode(), keyValues);
            return this;
        }

        public TarantoolDeleteRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_SPACE_ID.getCode())) {
                throw new TarantoolProtocolException("Space ID must be specified in the delete request");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode())) {
                throw new TarantoolProtocolException("Index ID must be specified in the delete request");
            }
            if ((Integer)this.bodyMap.get(TarantoolRequestFieldType.IPROTO_INDEX_ID.getCode()) != 0) {
                throw new TarantoolProtocolException("A delete request can only be executed for the primary key");
            }
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_KEY.getCode())) {
                throw new TarantoolProtocolException("Key values must be specified in the delete request");
            }
            return new TarantoolDeleteRequest(new TarantoolRequestBody(this.bodyMap, mapper), this.signature);
        }
    }
}

