/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.driver.protocol.requests;

import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.protocol.TarantoolProtocolException;
import io.tarantool.driver.protocol.TarantoolRequest;
import io.tarantool.driver.protocol.TarantoolRequestBody;
import io.tarantool.driver.protocol.TarantoolRequestFieldType;
import io.tarantool.driver.protocol.TarantoolRequestSignature;
import io.tarantool.driver.protocol.TarantoolRequestType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class TarantoolEvalRequest
extends TarantoolRequest {
    private TarantoolEvalRequest(TarantoolRequestBody body, TarantoolRequestSignature signature) {
        super(TarantoolRequestType.IPROTO_EVAL, body, signature);
    }

    public static class Builder
    extends TarantoolRequest.Builder<Builder> {
        Map<Integer, Object> bodyMap = new HashMap<Integer, Object>(2, 1.0f);

        @Override
        protected Builder self() {
            return this;
        }

        public Builder withExpression(String expression) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_EXPRESSION.getCode(), expression);
            return this;
        }

        public Builder withArguments(Collection<?> arguments) {
            this.bodyMap.put(TarantoolRequestFieldType.IPROTO_TUPLE.getCode(), arguments);
            return this;
        }

        public TarantoolEvalRequest build(MessagePackObjectMapper mapper) throws TarantoolProtocolException {
            if (!this.bodyMap.containsKey(TarantoolRequestFieldType.IPROTO_EXPRESSION.getCode())) {
                throw new TarantoolProtocolException("Lua expression must be specified in the eval request");
            }
            return new TarantoolEvalRequest(new TarantoolRequestBody(this.bodyMap, mapper), this.signature);
        }
    }
}

