/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.wildfly.swarm.spi.meta.FractionDetector;

public abstract class PackageFractionDetector
implements FractionDetector<String> {
    private boolean detected = false;
    private boolean detectionComplete = false;
    private Collection<String> anyPackages = new HashSet<String>();
    private Collection<String> anyClasses = new HashSet<String>();
    private Map<String, Boolean> allPackages = new HashMap<String, Boolean>();

    @Override
    public String extensionToDetect() {
        return "class";
    }

    @Override
    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    @Override
    public boolean wasDetected() {
        return this.detected;
    }

    @Override
    public void detect(String element) {
        if (!this.detectionComplete() && element != null) {
            this.detected = this.anyPackages.stream().anyMatch(element::startsWith);
            if (this.detected) {
                this.detectionComplete = true;
                return;
            }
            this.detected = this.anyClasses.stream().anyMatch(element::equals);
            if (this.detected) {
                this.detectionComplete = true;
                return;
            }
            if (this.allPackages.size() > 0) {
                this.allPackages.entrySet().stream().filter(e -> element.startsWith((String)e.getKey())).forEach(e -> e.setValue(Boolean.TRUE));
                long found = this.allPackages.values().stream().filter(v -> v.equals(Boolean.TRUE)).count();
                if (found == (long)this.allPackages.size()) {
                    this.detected = true;
                    this.detectionComplete = true;
                }
            }
        }
    }

    public void anyPackageOf(String ... packages) {
        Collections.addAll(this.anyPackages, packages);
    }

    public void anyClassOf(String ... classes) {
        Collections.addAll(this.anyClasses, classes);
    }

    public void allPackages(String ... packages) {
        for (String pkg : packages) {
            this.allPackages.put(pkg, Boolean.FALSE);
        }
    }
}

