/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import java.net.InetSocketAddress;

public class LocalPortAttribute
implements ExchangeAttribute {
    public static final String LOCAL_PORT_SHORT = "%p";
    public static final String LOCAL_PORT = "%{LOCAL_PORT}";
    public static final ExchangeAttribute INSTANCE = new LocalPortAttribute();

    private LocalPortAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress localAddress = (InetSocketAddress)exchange.getConnection().getLocalAddress();
        return Integer.toString(localAddress.getPort());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Local port", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Local Port";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(LocalPortAttribute.LOCAL_PORT) || token.equals(LocalPortAttribute.LOCAL_PORT_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

