/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class ResponseCodeAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_CODE_SHORT = "%s";
    public static final String RESPONSE_CODE = "%{RESPONSE_CODE}";
    public static final ExchangeAttribute INSTANCE = new ResponseCodeAttribute();

    private ResponseCodeAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return Integer.toString(exchange.getResponseCode());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setResponseCode(Integer.parseInt(newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response code";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseCodeAttribute.RESPONSE_CODE) || token.equals(ResponseCodeAttribute.RESPONSE_CODE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

