/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.channels.FixedLengthOverflowException;
import org.xnio.channels.FixedLengthUnderflowException;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class FixedLengthStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final int config;
    private final ConduitListener<? super FixedLengthStreamSinkConduit> finishListener;
    private long state;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final long FLAG_CLOSE_REQUESTED = Long.MIN_VALUE;
    private static final long FLAG_CLOSE_COMPLETE = 0x4000000000000000L;
    private static final long FLAG_FINISHED_CALLED = 0x2000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask((int)0, (int)60);

    public FixedLengthStreamSinkConduit(StreamSinkConduit next, long contentLength, boolean configurable, boolean propagateClose, ConduitListener<? super FixedLengthStreamSinkConduit> finishListener) {
        super(next);
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.finishListener = finishListener;
        this.config = (configurable ? 1 : 0) | (propagateClose ? 2 : 0);
        this.state = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        long val = this.state;
        long remaining = val & MASK_COUNT;
        if (!src.hasRemaining()) {
            return 0;
        }
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        if ((long)src.remaining() > remaining) {
            throw new FixedLengthOverflowException();
        }
        int res = 0;
        try {
            int n = res = ((StreamSinkConduit)this.next).write(src);
            return n;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long val = this.state;
        long remaining = val & MASK_COUNT;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        long toWrite = Buffers.remaining((Buffer[])srcs, (int)offset, (int)length);
        if (toWrite > remaining) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return l;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(src, position, Math.min(count, val & MASK_COUNT));
            return l;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(source, Math.min(count, val & MASK_COUNT), throughBuffer);
            return l;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return true;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.exitFlush(val, flushed);
        }
    }

    public void suspendWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return;
        }
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    public void resumeWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return;
        }
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    public boolean isWriteResumed() {
        return Bits.allAreClear((long)this.state, (long)0x4000000000000000L) && ((StreamSinkConduit)this.next).isWriteResumed();
    }

    public void wakeupWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)0x4000000000000000L)) {
            return;
        }
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    public void terminateWrites() throws IOException {
        long val = this.enterShutdown();
        if (Bits.anyAreSet((long)val, (long)MASK_COUNT)) {
            try {
                throw new FixedLengthUnderflowException((val & MASK_COUNT) + " bytes remaining");
            }
            catch (Throwable throwable) {
                ((StreamSinkConduit)this.next).truncateWrites();
                throw throwable;
            }
        }
        if (Bits.allAreSet((int)this.config, (int)2)) {
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private void exitWrite(long oldVal, long consumed) {
        long newVal;
        this.state = newVal = oldVal - consumed;
    }

    private void exitFlush(long oldVal, boolean flushed) {
        long newVal = oldVal;
        boolean callFinish = false;
        if ((Bits.anyAreSet((long)oldVal, (long)Long.MIN_VALUE) || (newVal & MASK_COUNT) == 0L) && flushed) {
            if (!Bits.anyAreSet((long)oldVal, (long)0x2000000000000000L) && ((newVal |= 0x4000000000000000L) & MASK_COUNT) == 0L) {
                newVal |= 0x2000000000000000L;
                callFinish = true;
            }
            this.state = newVal;
            if (callFinish && this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
        }
    }

    private long enterShutdown() {
        long oldVal = this.state;
        if (Bits.anyAreSet((long)oldVal, (long)-4611686018427387904L)) {
            return oldVal;
        }
        long newVal = oldVal | Long.MIN_VALUE;
        if (Bits.anyAreSet((long)oldVal, (long)MASK_COUNT)) {
            newVal |= 0x4000000000000000L;
        }
        this.state = newVal;
        return oldVal;
    }
}

