/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

class MinContentSizePredicate
implements Predicate {
    private final long minSize;

    public MinContentSizePredicate(long minSize) {
        this.minSize = minSize;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String length = value.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (length == null) {
            return false;
        }
        return Long.parseLong(length) < this.minSize;
    }
}

