/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class Http2ClientProvider
implements ClientProvider {
    private static final String PROTOCOL_KEY;
    private static final String HTTP2 = "h2-14";
    private static final String HTTP_1_1 = "http/1.1";
    private static final List<String> PROTOCOLS;
    private static final Method ALPN_PUT_METHOD;

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("h2"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (ALPN_PUT_METHOD == null) {
            listener.failed(UndertowMessages.MESSAGES.jettyNPNNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        if (bindAddress == null) {
            ssl.openSslConnection(worker, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(worker, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        }
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (ALPN_PUT_METHOD == null) {
            listener.failed(UndertowMessages.MESSAGES.jettyNPNNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        if (bindAddress == null) {
            ssl.openSslConnection(ioThread, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(ioThread, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        }
    }

    private IoFuture.Notifier<StreamConnection, Object> createNotifier(final ClientCallback<ClientConnection> listener) {
        return new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
    }

    private ChannelListener<StreamConnection> createOpenListener(final ClientCallback<ClientConnection> listener, final URI uri, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                Http2ClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
    }

    private void handleConnected(StreamConnection connection, final ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        Http2ClientProvider.handlePotentialHttp2Connection(connection, listener, bufferPool, options, new ChannelListener<SslConnection>(){

            public void handleEvent(SslConnection channel) {
                listener.failed(UndertowMessages.MESSAGES.spdyNotSupported());
            }
        });
    }

    public static boolean isEnabled() {
        return ALPN_PUT_METHOD != null;
    }

    public static void handlePotentialHttp2Connection(final StreamConnection connection, final ClientCallback<ClientConnection> listener, final Pool<ByteBuffer> bufferPool, final OptionMap options, final ChannelListener<SslConnection> http2FailedListener) {
        final SslConnection sslConnection = (SslConnection)connection;
        SSLEngine sslEngine = JsseXnioSsl.getSslEngine((SslConnection)sslConnection);
        String existing = (String)sslEngine.getSession().getValue(PROTOCOL_KEY);
        if (existing != null) {
            if (existing.equals(HTTP2)) {
                listener.completed(Http2ClientProvider.createHttp2Channel(connection, bufferPool, options));
            } else {
                sslConnection.getSourceChannel().suspendReads();
                http2FailedListener.handleEvent((Channel)sslConnection);
            }
        } else {
            final SpdySelectionProvider spdySelectionProvider = new SpdySelectionProvider(sslEngine);
            try {
                ALPN_PUT_METHOD.invoke(null, sslEngine, spdySelectionProvider);
            }
            catch (Exception e) {
                http2FailedListener.handleEvent((Channel)sslConnection);
                return;
            }
            try {
                sslConnection.startHandshake();
                sslConnection.getSourceChannel().getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                    public void handleEvent(StreamSourceChannel channel) {
                        if (spdySelectionProvider.selected != null) {
                            if (spdySelectionProvider.selected.equals(Http2ClientProvider.HTTP_1_1)) {
                                sslConnection.getSourceChannel().suspendReads();
                                http2FailedListener.handleEvent((Channel)sslConnection);
                                return;
                            }
                            if (spdySelectionProvider.selected.equals(Http2ClientProvider.HTTP2)) {
                                listener.completed(Http2ClientProvider.createHttp2Channel(connection, (Pool<ByteBuffer>)bufferPool, options));
                            }
                        } else {
                            ByteBuffer buf = ByteBuffer.allocate(100);
                            try {
                                int read = channel.read(buf);
                                if (read > 0) {
                                    PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
                                    pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                    connection.getSourceChannel().setConduit((StreamSourceConduit)pb);
                                }
                                if (spdySelectionProvider.selected == null && read > 0 || Http2ClientProvider.HTTP_1_1.equals(spdySelectionProvider.selected)) {
                                    sslConnection.getSourceChannel().suspendReads();
                                    http2FailedListener.handleEvent((Channel)sslConnection);
                                    return;
                                }
                                if (spdySelectionProvider.selected != null && spdySelectionProvider.selected.equals(Http2ClientProvider.HTTP2)) {
                                    listener.completed(Http2ClientProvider.createHttp2Channel(connection, (Pool<ByteBuffer>)bufferPool, options));
                                }
                            }
                            catch (IOException e) {
                                listener.failed(e);
                            }
                        }
                    }
                });
                sslConnection.getSourceChannel().resumeReads();
            }
            catch (IOException e) {
                listener.failed(e);
            }
            catch (Throwable e) {
                listener.failed(new IOException(e));
            }
        }
    }

    private static Http2ClientConnection createHttp2Channel(StreamConnection connection, Pool<ByteBuffer> bufferPool, OptionMap options) {
        Http2Channel http2Channel = new Http2Channel(connection, bufferPool, null, true, false, options);
        return new Http2ClientConnection(http2Channel, false);
    }

    static {
        Method npnPutMethod;
        PROTOCOL_KEY = Http2ClientProvider.class.getName() + ".protocol";
        PROTOCOLS = Collections.unmodifiableList(Arrays.asList(HTTP2, HTTP_1_1));
        try {
            Class<?> npnClass = Class.forName("org.eclipse.jetty.alpn.ALPN", false, Http2ClientProvider.class.getClassLoader());
            npnPutMethod = npnClass.getDeclaredMethod("put", SSLEngine.class, Class.forName("org.eclipse.jetty.alpn.ALPN$Provider", false, Http2ClientProvider.class.getClassLoader()));
        }
        catch (Exception e) {
            UndertowLogger.CLIENT_LOGGER.jettyALPNNotFound("HTTP2");
            npnPutMethod = null;
        }
        ALPN_PUT_METHOD = npnPutMethod;
    }

    private static class SpdySelectionProvider
    implements ALPN.ClientProvider {
        private String selected;
        private final SSLEngine sslEngine;

        private SpdySelectionProvider(SSLEngine sslEngine) {
            this.sslEngine = sslEngine;
        }

        public boolean supports() {
            return true;
        }

        public List<String> protocols() {
            return PROTOCOLS;
        }

        public void unsupported() {
            this.selected = Http2ClientProvider.HTTP_1_1;
        }

        public void selected(String s) {
            ALPN.remove((SSLEngine)this.sslEngine);
            this.selected = s;
            this.sslEngine.getSession().putValue(PROTOCOL_KEY, this.selected);
        }

        private String getSelected() {
            return this.selected;
        }
    }
}

