/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class Transfer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, Pool<ByteBuffer> pool) {
        if (pool == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("pool");
        }
        Pooled allocated = pool.allocate();
        boolean free = true;
        try {
            long read;
            ByteBuffer buffer = (ByteBuffer)allocated.getResource();
            while (true) {
                try {
                    read = source.read(buffer);
                    buffer.flip();
                }
                catch (IOException e) {
                    ChannelListeners.invokeChannelExceptionHandler(source, readExceptionHandler, (IOException)e);
                    if (free) {
                        allocated.free();
                    }
                    return;
                }
                if (read == 0L && !buffer.hasRemaining()) break;
                if (read == -1L && !buffer.hasRemaining()) {
                    Transfer.done(source, sink, sourceListener, sinkListener);
                    return;
                }
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = sink.write(buffer);
                    }
                    catch (IOException e) {
                        ChannelListeners.invokeChannelExceptionHandler(sink, writeExceptionHandler, (IOException)e);
                        if (free) {
                            allocated.free();
                        }
                        return;
                    }
                    if (res != 0) continue;
                    break;
                }
                if (buffer.hasRemaining()) break;
                buffer.clear();
            }
            Pooled current = null;
            if (buffer.hasRemaining()) {
                current = allocated;
                free = false;
            }
            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(pool, (Pooled<ByteBuffer>)current, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, read == -1L);
            sink.getWriteSetter().set(listener);
            source.getReadSetter().set(listener);
            if (current == null || buffer.capacity() != buffer.remaining()) {
                source.resumeReads();
            }
            if (current != null) {
                sink.resumeWrites();
            }
        }
        finally {
            if (free) {
                allocated.free();
            }
        }
    }

    private static <I extends StreamSourceChannel, O extends StreamSinkChannel> void done(I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener) {
        Channels.setReadListener(source, sourceListener);
        if (sourceListener == null) {
            source.suspendReads();
        } else {
            source.wakeupReads();
        }
        Channels.setWriteListener(sink, sinkListener);
        if (sinkListener == null) {
            sink.suspendWrites();
        } else {
            sink.wakeupWrites();
        }
    }

    static final class TransferListener<I extends StreamSourceChannel, O extends StreamSinkChannel>
    implements ChannelListener<Channel> {
        private Pooled<ByteBuffer> pooledBuffer;
        private final Pool<ByteBuffer> pool;
        private final I source;
        private final O sink;
        private final ChannelListener<? super I> sourceListener;
        private final ChannelListener<? super O> sinkListener;
        private final ChannelExceptionHandler<? super O> writeExceptionHandler;
        private final ChannelExceptionHandler<? super I> readExceptionHandler;
        private boolean sourceDone;
        private boolean done = false;

        TransferListener(Pool<ByteBuffer> pool, Pooled<ByteBuffer> pooledBuffer, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super O> writeExceptionHandler, ChannelExceptionHandler<? super I> readExceptionHandler, boolean sourceDone) {
            this.pool = pool;
            this.pooledBuffer = pooledBuffer;
            this.source = source;
            this.sink = sink;
            this.sourceListener = sourceListener;
            this.sinkListener = sinkListener;
            this.writeExceptionHandler = writeExceptionHandler;
            this.readExceptionHandler = readExceptionHandler;
            this.sourceDone = sourceDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Channel channel) {
            if (this.done) {
                if (channel instanceof StreamSinkChannel) {
                    ((StreamSinkChannel)channel).suspendWrites();
                } else if (channel instanceof StreamSourceChannel) {
                    ((StreamSourceChannel)channel).suspendReads();
                }
                return;
            }
            boolean noWrite = false;
            if (this.pooledBuffer == null) {
                this.pooledBuffer = this.pool.allocate();
                noWrite = true;
            } else if (channel instanceof StreamSourceChannel) {
                noWrite = true;
                ((ByteBuffer)this.pooledBuffer.getResource()).compact();
            }
            ByteBuffer buffer = (ByteBuffer)this.pooledBuffer.getResource();
            try {
                while (true) {
                    boolean writeFailed = false;
                    if (!noWrite) {
                        while (buffer.hasRemaining()) {
                            int res;
                            try {
                                res = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.pooledBuffer.free();
                                this.pooledBuffer = null;
                                this.done = true;
                                ChannelListeners.invokeChannelExceptionHandler(this.sink, this.writeExceptionHandler, (IOException)e);
                                if (this.pooledBuffer != null && !buffer.hasRemaining()) {
                                    this.pooledBuffer.free();
                                    this.pooledBuffer = null;
                                }
                                return;
                            }
                            if (res != 0) continue;
                            writeFailed = true;
                            break;
                        }
                        if (this.sourceDone && !buffer.hasRemaining()) {
                            this.done = true;
                            Transfer.done(this.source, this.sink, this.sourceListener, this.sinkListener);
                            return;
                        }
                        buffer.compact();
                    }
                    noWrite = false;
                    if (buffer.hasRemaining() && !this.sourceDone) {
                        long read;
                        try {
                            read = this.source.read(buffer);
                            buffer.flip();
                        }
                        catch (IOException e) {
                            this.pooledBuffer.free();
                            this.pooledBuffer = null;
                            this.done = true;
                            ChannelListeners.invokeChannelExceptionHandler(this.source, this.readExceptionHandler, (IOException)e);
                            if (this.pooledBuffer != null && !buffer.hasRemaining()) {
                                this.pooledBuffer.free();
                                this.pooledBuffer = null;
                            }
                            return;
                        }
                        if (read != 0L) {
                            if (read != -1L) continue;
                            this.sourceDone = true;
                            if (buffer.hasRemaining()) continue;
                            this.done = true;
                            Transfer.done(this.source, this.sink, this.sourceListener, this.sinkListener);
                            return;
                        }
                        break;
                    }
                    buffer.flip();
                    if (writeFailed) break;
                }
                if (!buffer.hasRemaining()) {
                    this.sink.suspendWrites();
                } else if (!this.sink.isWriteResumed()) {
                    this.sink.resumeWrites();
                }
                if (buffer.remaining() == buffer.capacity()) {
                    this.source.suspendReads();
                } else if (!this.source.isReadResumed()) {
                    this.source.resumeReads();
                }
            }
            finally {
                if (this.pooledBuffer != null && !buffer.hasRemaining()) {
                    this.pooledBuffer.free();
                    this.pooledBuffer = null;
                }
            }
        }

        public String toString() {
            return "Transfer channel listener (" + this.source + " to " + this.sink + ") -> (" + this.sourceListener + " and " + this.sinkListener + ")";
        }
    }
}

