/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.util.CopyOnWriteMap;
import java.util.HashMap;
import java.util.Map;

public class Servlets {
    private final Map<String, ServletHandler> managedServletMap = new CopyOnWriteMap();
    private final DeploymentImpl deployment;
    private final ServletPathMatches servletPaths;

    public Servlets(DeploymentImpl deployment, ServletPathMatches servletPaths) {
        this.deployment = deployment;
        this.servletPaths = servletPaths;
    }

    public ServletHandler addServlet(ServletInfo servletInfo) {
        ManagedServlet managedServlet = new ManagedServlet(servletInfo, this.deployment.getServletContext());
        ServletHandler servletHandler = new ServletHandler(managedServlet);
        this.managedServletMap.put(servletInfo.getName(), servletHandler);
        this.deployment.addLifecycleObjects(managedServlet);
        this.servletPaths.invalidate();
        return servletHandler;
    }

    public ManagedServlet getManagedServlet(String name) {
        ServletHandler servletHandler = this.managedServletMap.get(name);
        if (servletHandler == null) {
            return null;
        }
        return servletHandler.getManagedServlet();
    }

    public ServletHandler getServletHandler(String name) {
        return this.managedServletMap.get(name);
    }

    public Map<String, ServletHandler> getServletHandlers() {
        return new HashMap<String, ServletHandler>(this.managedServletMap);
    }
}

