/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.spec.WebConnectionImpl;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements ExchangeCompletionListener {
    private final InstanceHandle<T> instance;
    private final ThreadSetupAction threadSetupAction;

    public ServletUpgradeListener(InstanceHandle<T> instance, ThreadSetupAction threadSetupAction) {
        this.instance = instance;
        this.threadSetupAction = threadSetupAction;
    }

    public void exchangeEvent(final HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        final StreamConnection channel = exchange.getConnection().upgradeChannel();
        exchange.getConnection().addCloseListener(new ServerConnection.CloseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closed(ServerConnection connection) {
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).destroy();
                }
                finally {
                    try {
                        handle.tearDown();
                    }
                    finally {
                        ServletUpgradeListener.this.instance.release();
                    }
                }
            }
        });
        exchange.getIoThread().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).init((WebConnection)new WebConnectionImpl(channel));
                }
                finally {
                    handle.tearDown();
                }
            }
        });
    }
}

