/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.servlet.api.AuthMethodConfig;
import java.util.LinkedList;
import java.util.List;

public class LoginConfig
implements Cloneable {
    private final LinkedList<AuthMethodConfig> authMethods = new LinkedList();
    private final String realmName;
    private final String loginPage;
    private final String errorPage;

    public LoginConfig(String realmName, String loginPage, String errorPage) {
        this.realmName = realmName;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
    }

    public LoginConfig(String realmName) {
        this(realmName, null, null);
    }

    public LoginConfig(String mechanismName, String realmName, String loginPage, String errorPage) {
        this.realmName = realmName;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.addFirstAuthMethod(mechanismName);
    }

    public LoginConfig(String mechanismName, String realmName) {
        this(mechanismName, realmName, null, null);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public LoginConfig addFirstAuthMethod(AuthMethodConfig authMethodConfig) {
        this.authMethods.add(authMethodConfig);
        return this;
    }

    public LoginConfig addLastAuthMethod(AuthMethodConfig authMethodConfig) {
        this.authMethods.addLast(authMethodConfig);
        return this;
    }

    public LoginConfig addFirstAuthMethod(String authMethodConfig) {
        this.authMethods.add(new AuthMethodConfig(authMethodConfig));
        return this;
    }

    public LoginConfig addLastAuthMethod(String authMethodConfig) {
        this.authMethods.addLast(new AuthMethodConfig(authMethodConfig));
        return this;
    }

    public List<AuthMethodConfig> getAuthMethods() {
        return this.authMethods;
    }

    public LoginConfig clone() {
        LoginConfig lc = new LoginConfig(this.realmName, this.loginPage, this.errorPage);
        for (AuthMethodConfig method : this.authMethods) {
            lc.authMethods.add(method.clone());
        }
        return lc;
    }
}

