/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class SessionListenerBridge
implements SessionListener {
    public static final String IO_UNDERTOW = "io.undertow";
    private final ThreadSetupAction threadSetup;
    private final ApplicationListeners applicationListeners;
    private final ServletContext servletContext;

    public SessionListenerBridge(ThreadSetupAction threadSetup, ApplicationListeners applicationListeners, ServletContext servletContext) {
        this.threadSetup = threadSetup;
        this.applicationListeners = applicationListeners;
        this.servletContext = servletContext;
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, true);
        this.applicationListeners.sessionCreated(httpSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        ThreadSetupAction.Handle handle = null;
        try {
            HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
            if (reason == SessionListener.SessionDestroyedReason.TIMEOUT) {
                handle = this.threadSetup.setup(exchange);
            }
            this.applicationListeners.sessionDestroyed(httpSession);
            HashSet names = new HashSet(session.getAttributeNames());
            for (String attribute : names) {
                session.removeAttribute(attribute);
            }
        }
        finally {
            ServletRequestContext current;
            if (handle != null) {
                handle.tearDown();
            }
            if ((current = SecurityActions.currentServletRequestContext()) != null) {
                current.setSession(null);
            }
        }
    }

    public void attributeAdded(Session session, String name, Object value) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        this.applicationListeners.httpSessionAttributeAdded(httpSession, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)httpSession, name, value));
        }
    }

    public void attributeUpdated(Session session, String name, Object value, Object old) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        if (old != value) {
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, name, old));
            }
            this.applicationListeners.httpSessionAttributeReplaced(httpSession, name, old);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)httpSession, name, value));
        }
    }

    public void attributeRemoved(Session session, String name, Object old) {
        if (name.startsWith(IO_UNDERTOW)) {
            return;
        }
        HttpSessionImpl httpSession = SecurityActions.forSession(session, this.servletContext, false);
        if (old != null) {
            this.applicationListeners.httpSessionAttributeRemoved(httpSession, name, old);
            if (old instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)old).valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, name, old));
            }
        }
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
    }
}

