/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.streams.ReadStream;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;

public class GrpcClientResponseImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcClientResponseImpl<Req, Resp>, Resp>
implements GrpcClientResponse<Req, Resp> {
    private final GrpcClientRequestImpl<Req, Resp> request;
    private final HttpClientResponse httpResponse;
    private GrpcStatus status;
    private String encoding;

    public GrpcClientResponseImpl(GrpcClientRequestImpl<Req, Resp> request, HttpClientResponse httpResponse, GrpcMessageDecoder<Resp> messageDecoder) {
        super(Vertx.currentContext(), (ReadStream)httpResponse, httpResponse.headers().get("grpc-encoding"), messageDecoder);
        this.request = request;
        this.encoding = httpResponse.headers().get("grpc-encoding");
        this.httpResponse = httpResponse;
        String responseStatus = httpResponse.getHeader("grpc-status");
        if (responseStatus != null) {
            this.status = GrpcStatus.valueOf((int)Integer.parseInt(responseStatus));
        }
    }

    public MultiMap headers() {
        return this.httpResponse.headers();
    }

    public String encoding() {
        return this.encoding;
    }

    @Override
    public MultiMap trailers() {
        return this.httpResponse.trailers();
    }

    protected void handleEnd() {
        String responseStatus = this.httpResponse.getTrailer("grpc-status");
        if (responseStatus != null) {
            this.status = GrpcStatus.valueOf((int)Integer.parseInt(responseStatus));
        }
        super.handleEnd();
        if (!this.request.trailersSent) {
            this.request.cancel();
        }
    }

    @Override
    public GrpcStatus status() {
        return this.status;
    }

    public Future<Void> end() {
        return super.end().compose(v -> {
            if (this.status == GrpcStatus.OK) {
                return Future.succeededFuture();
            }
            return Future.failedFuture((String)("Invalid gRPC status " + this.status));
        });
    }

    @Override
    public GrpcClientResponseImpl<Req, Resp> handler(Handler<Resp> handler) {
        if (handler != null) {
            return (GrpcClientResponseImpl)this.messageHandler(msg -> {
                Object decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    this.request.cancel();
                    return;
                }
                handler.handle(decoded);
            });
        }
        return (GrpcClientResponseImpl)this.messageHandler(null);
    }
}

