/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.helloworld;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class GreeterGrpc {
    public static final String SERVICE_NAME = "helloworld.Greeter";
    public static final MethodDescriptor<HelloRequest, HelloReply> METHOD_SAY_HELLO = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"helloworld.Greeter", (String)"SayHello"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)HelloRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)HelloReply.getDefaultInstance()));
    private static final int METHODID_SAY_HELLO = 0;

    private GreeterGrpc() {
    }

    public static GreeterStub newStub(Channel channel) {
        return new GreeterStub(channel);
    }

    public static GreeterBlockingStub newBlockingStub(Channel channel) {
        return new GreeterBlockingStub(channel);
    }

    public static GreeterFutureStub newFutureStub(Channel channel) {
        return new GreeterFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_SAY_HELLO});
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final GreeterImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(GreeterImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.sayHello((HelloRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static final class GreeterFutureStub
    extends AbstractStub<GreeterFutureStub> {
        private GreeterFutureStub(Channel channel) {
            super(channel);
        }

        private GreeterFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterFutureStub build(Channel channel, CallOptions callOptions) {
            return new GreeterFutureStub(channel, callOptions);
        }

        public ListenableFuture<HelloReply> sayHello(HelloRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request);
        }
    }

    public static final class GreeterBlockingStub
    extends AbstractStub<GreeterBlockingStub> {
        private GreeterBlockingStub(Channel channel) {
            super(channel);
        }

        private GreeterBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterBlockingStub build(Channel channel, CallOptions callOptions) {
            return new GreeterBlockingStub(channel, callOptions);
        }

        public HelloReply sayHello(HelloRequest request) {
            return (HelloReply)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_SAY_HELLO, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class GreeterStub
    extends AbstractStub<GreeterStub> {
        private GreeterStub(Channel channel) {
            super(channel);
        }

        private GreeterStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected GreeterStub build(Channel channel, CallOptions callOptions) {
            return new GreeterStub(channel, callOptions);
        }

        public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_SAY_HELLO, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class GreeterImplBase
    implements BindableService {
        public void sayHello(HelloRequest request, StreamObserver<HelloReply> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_SAY_HELLO, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)GreeterGrpc.getServiceDescriptor()).addMethod(METHOD_SAY_HELLO, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).build();
        }
    }
}

