/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.propagation.Propagation;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class PropagationSetterTest<C, K> {
    protected abstract Propagation.KeyFactory<K> keyFactory();

    protected abstract C carrier();

    protected abstract Propagation.Setter<C, K> setter();

    protected abstract Iterable<String> read(C var1, K var2);

    @Test
    public void set() throws Exception {
        Object key = this.keyFactory().create("X-B3-TraceId");
        this.setter().put(this.carrier(), key, "48485a3953bb6124");
        Assertions.assertThat(this.read(this.carrier(), key)).containsExactly((Object[])new String[]{"48485a3953bb6124"});
    }

    @Test
    public void set128() throws Exception {
        Object key = this.keyFactory().create("X-B3-TraceId");
        this.setter().put(this.carrier(), key, "463ac35c9f6413ad48485a3953bb6124");
        Assertions.assertThat(this.read(this.carrier(), key)).containsExactly((Object[])new String[]{"463ac35c9f6413ad48485a3953bb6124"});
    }

    @Test
    public void setTwoKeys() throws Exception {
        Object key1 = this.keyFactory().create("X-B3-TraceId");
        Object key2 = this.keyFactory().create("X-B3-SpanId");
        this.setter().put(this.carrier(), key1, "463ac35c9f6413ad48485a3953bb6124");
        this.setter().put(this.carrier(), key2, "48485a3953bb6124");
        Assertions.assertThat(this.read(this.carrier(), key1)).containsExactly((Object[])new String[]{"463ac35c9f6413ad48485a3953bb6124"});
        Assertions.assertThat(this.read(this.carrier(), key2)).containsExactly((Object[])new String[]{"48485a3953bb6124"});
    }

    @Test
    public void reset() throws Exception {
        Object key = this.keyFactory().create("X-B3-TraceId");
        this.setter().put(this.carrier(), key, "48485a3953bb6124");
        this.setter().put(this.carrier(), key, "463ac35c9f6413ad");
        Assertions.assertThat(this.read(this.carrier(), key)).containsExactly((Object[])new String[]{"463ac35c9f6413ad"});
    }
}

