/*
 * Decompiled with CFR 0.152.
 */
package brave.test.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class CurrentTraceContextTest {
    protected final CurrentTraceContext currentTraceContext = this.newCurrentTraceContext();
    protected final TraceContext context = TraceContext.newBuilder().traceId(1L).spanId(1L).build();
    protected final TraceContext context2 = TraceContext.newBuilder().traceId(1L).parentId(1L).spanId(2L).build();

    protected abstract CurrentTraceContext newCurrentTraceContext();

    protected CurrentTraceContextTest() {
    }

    protected void verifyImplicitContext(@Nullable TraceContext context) {
    }

    @Test
    public void currentSpan_defaultsToNull() {
        Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
    }

    @Test
    public void scope_retainsContext() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    @Test
    public void scope_canClearScope() {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            try (CurrentTraceContext.Scope noScope = this.currentTraceContext.newScope(null);){
                Assertions.assertThat((Object)this.currentTraceContext.get()).isNull();
                this.verifyImplicitContext(null);
            }
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    protected void is_inheritable(CurrentTraceContext inheritableCurrentTraceContext) throws Exception {
        ThreadPoolExecutor service = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try (CurrentTraceContext.Scope scope = inheritableCurrentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> inheritableCurrentTraceContext.get()).get()).isEqualTo((Object)this.context);
        }
        Assertions.assertThat((Object)service.submit(() -> inheritableCurrentTraceContext.get()).get()).isEqualTo((Object)this.context);
        service.shutdownNow();
    }

    @Test
    public void isnt_inheritable() throws Exception {
        ExecutorService service = Executors.newCachedThreadPool();
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            Assertions.assertThat((Object)service.submit(() -> {
                this.verifyImplicitContext(null);
                return this.currentTraceContext.get();
            }).get()).isNull();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw (Exception)e.getCause();
        }
        Assertions.assertThat((Object)service.submit(() -> this.currentTraceContext.get()).get()).isNull();
        this.verifyImplicitContext(null);
        service.shutdownNow();
    }

    @Test
    public void attachesSpanInCallable() throws Exception {
        Callable callable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            callable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
                return true;
            });
        }
        var3_2 = null;
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.context2);){
            callable.call();
            this.verifyImplicitContext(this.context2);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void restoresSpanAfterCallable() throws Exception {
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(this.context);){
            this.attachesSpanInCallable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
            this.verifyImplicitContext(this.context);
        }
    }

    @Test
    public void attachesSpanInRunnable() throws Exception {
        Runnable runnable;
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(this.context);){
            runnable = this.currentTraceContext.wrap(() -> {
                Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)this.context);
                this.verifyImplicitContext(this.context);
            });
        }
        var3_2 = null;
        try (CurrentTraceContext.Scope scope2 = this.currentTraceContext.newScope(this.context2);){
            runnable.run();
            this.verifyImplicitContext(this.context2);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void restoresSpanAfterRunnable() throws Exception {
        TraceContext context0 = TraceContext.newBuilder().traceId(3L).spanId(3L).build();
        try (CurrentTraceContext.Scope scope0 = this.currentTraceContext.newScope(context0);){
            this.attachesSpanInRunnable();
            Assertions.assertThat((Object)this.currentTraceContext.get()).isEqualTo((Object)context0);
            this.verifyImplicitContext(context0);
        }
    }
}

