/*
 * Decompiled with CFR 0.152.
 */
package zipkin.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Table;
import org.jooq.conf.Settings;
import zipkin.AsyncSpanConsumer;
import zipkin.AsyncSpanStore;
import zipkin.CollectorMetrics;
import zipkin.CollectorSampler;
import zipkin.SpanStore;
import zipkin.StorageAdapters;
import zipkin.StorageComponent;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.jdbc.DSLContexts;
import zipkin.jdbc.JDBCSpanConsumer;
import zipkin.jdbc.JDBCSpanStore;
import zipkin.jdbc.internal.generated.tables.ZipkinAnnotations;
import zipkin.jdbc.internal.generated.tables.ZipkinSpans;

public final class JDBCStorage
implements StorageComponent {
    private final DataSource datasource;
    private final Executor executor;
    private final DSLContexts context;
    private final SpanStore spanStore;
    private final AsyncSpanStore asyncSpanStore;
    private final StorageAdapters.SpanConsumer spanConsumer;
    private final AsyncSpanConsumer asyncSpanConsumer;

    public static Builder builder() {
        return new Builder();
    }

    JDBCStorage(Builder builder) {
        this.datasource = builder.datasource;
        this.executor = builder.executor;
        this.context = new DSLContexts(builder.settings, builder.listenerProvider);
        this.spanStore = new JDBCSpanStore(this.datasource, this.context);
        this.asyncSpanStore = StorageAdapters.blockingToAsync((SpanStore)this.spanStore, (Executor)this.executor);
        this.spanConsumer = new JDBCSpanConsumer(this.datasource, this.context);
        this.asyncSpanConsumer = StorageAdapters.blockingToAsync((StorageAdapters.SpanConsumer)this.spanConsumer, (Executor)this.executor);
    }

    public SpanStore spanStore() {
        return this.spanStore;
    }

    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public StorageAdapters.SpanConsumer spanConsumer() {
        return this.spanConsumer;
    }

    public AsyncSpanConsumer asyncSpanConsumer(CollectorSampler sampler, CollectorMetrics metrics) {
        return StorageAdapters.makeSampled((AsyncSpanConsumer)this.asyncSpanConsumer, (CollectorSampler)sampler, (CollectorMetrics)metrics);
    }

    public void close() {
    }

    void clear() {
        try (Connection conn = this.datasource.getConnection();){
            this.context.get(conn).truncate((Table)ZipkinSpans.ZIPKIN_SPANS).execute();
            this.context.get(conn).truncate((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).execute();
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        System.setProperty("org.jooq.no-logo", "true");
    }

    public static final class Builder {
        private DataSource datasource;
        private Settings settings = new Settings().withRenderSchema(Boolean.valueOf(false));
        private ExecuteListenerProvider listenerProvider;
        private Executor executor;

        public Builder datasource(DataSource datasource) {
            this.datasource = (DataSource)Util.checkNotNull((Object)datasource, (String)"datasource");
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = (Settings)Util.checkNotNull((Object)settings, (String)"settings");
            return this;
        }

        public Builder listenerProvider(@Nullable ExecuteListenerProvider listenerProvider) {
            this.listenerProvider = listenerProvider;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = (Executor)Util.checkNotNull((Object)executor, (String)"executor");
            return this;
        }

        public JDBCStorage build() {
            return new JDBCStorage(this);
        }

        Builder() {
        }
    }
}

