/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import zipkin2.reporter.Encoding;

public interface BytesMessageSender
extends Closeable {
    public Encoding encoding();

    public int messageMaxBytes();

    public int messageSizeInBytes(List<byte[]> var1);

    public int messageSizeInBytes(int var1);

    public void send(List<byte[]> var1) throws IOException;

    public static abstract class Base
    implements BytesMessageSender {
        protected final Encoding encoding;

        protected Base(Encoding encoding) {
            this.encoding = encoding;
        }

        @Override
        public Encoding encoding() {
            return this.encoding;
        }

        @Override
        public int messageSizeInBytes(List<byte[]> encodedSpans) {
            return this.encoding.listSizeInBytes(encodedSpans);
        }

        @Override
        public int messageSizeInBytes(int encodedSizeInBytes) {
            return this.encoding.listSizeInBytes(encodedSizeInBytes);
        }
    }
}

