/*
 * Decompiled with CFR 0.152.
 */
package com.ghasemkiani.gui.misc;

import com.ghasemkiani.util.DateFields;
import com.ghasemkiani.util.SimplePersianCalendar;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanelPersianGregorianDateConverter
extends JPanel {
    private JPanel jPanelGregorian = new JPanel(new GridBagLayout());
    private JLabel jLabelGregorianYear = new JLabel("Year");
    private JLabel jLabelGregorianMonth = new JLabel("Month");
    private JLabel jLabelGregorianDay = new JLabel("Day");
    private JTextField jTextFieldGregorianYear = new JTextField();
    private JTextField jTextFieldGregorianMonth = new JTextField();
    private JTextField jTextFieldGregorianDay = new JTextField();
    private JPanel jPanelPersian = new JPanel(new GridBagLayout());
    private JLabel jLabelPersianYear = new JLabel("Year");
    private JLabel jLabelPersianMonth = new JLabel("Month");
    private JLabel jLabelPersianDay = new JLabel("Day");
    private JTextField jTextFieldPersianYear = new JTextField();
    private JTextField jTextFieldPersianMonth = new JTextField();
    private JTextField jTextFieldPersianDay = new JTextField();
    private JTextField jTextFieldPersianText = new JTextField();
    private JLabel jLabelCopyRight = new JLabel("<html><center>&copy; 2003, Ghasem Kiani<br>[<font color='purple'>ghasemkiani@yahoo.com</font>]</center></html>", 0);
    private JPanel jPanelButtons = new JPanel(new FlowLayout());

    public JPanelPersianGregorianDateConverter() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jPanelGregorian, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.setBorder(BorderFactory.createTitledBorder("Gregorian"));
        this.jPanelGregorian.add((Component)this.jLabelGregorianYear, new GridBagConstraints(0, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.add((Component)this.jLabelGregorianMonth, new GridBagConstraints(1, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.add((Component)this.jLabelGregorianDay, new GridBagConstraints(2, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.add((Component)this.jTextFieldGregorianYear, new GridBagConstraints(0, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.add((Component)this.jTextFieldGregorianMonth, new GridBagConstraints(1, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelGregorian.add((Component)this.jTextFieldGregorianDay, new GridBagConstraints(2, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.jPanelPersian, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.setBorder(BorderFactory.createTitledBorder("Persian"));
        this.jPanelPersian.add((Component)this.jLabelPersianYear, new GridBagConstraints(0, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jLabelPersianMonth, new GridBagConstraints(1, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jLabelPersianDay, new GridBagConstraints(2, 0, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jTextFieldPersianYear, new GridBagConstraints(0, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jTextFieldPersianMonth, new GridBagConstraints(1, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jTextFieldPersianDay, new GridBagConstraints(2, 1, 1, 1, 0.333, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelPersian.add((Component)this.jTextFieldPersianText, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jTextFieldPersianText.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.jTextFieldPersianText.setEditable(false);
        this.add((Component)this.jLabelCopyRight, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 23, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.jPanelButtons, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 23, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelButtons.add(new JButton(new AbstractAction("To Persian"){

            public void actionPerformed(ActionEvent ae) {
                JPanelPersianGregorianDateConverter.this.convertGregorianToPersian();
            }
        }));
        this.jPanelButtons.add(new JButton(new AbstractAction("To Gregorian"){

            public void actionPerformed(ActionEvent ae) {
                JPanelPersianGregorianDateConverter.this.convertPersianToGregorian();
            }
        }));
        this.jPanelButtons.add(new JButton(new AbstractAction("Current"){

            public void actionPerformed(ActionEvent ae) {
                JPanelPersianGregorianDateConverter.this.setCurrentDate();
            }
        }));
        this.setCurrentDate();
    }

    private void convertGregorianToPersian() {
        try {
            int day;
            int month;
            int year;
            try {
                year = Integer.parseInt(this.jTextFieldGregorianYear.getText());
            }
            catch (NumberFormatException nfe) {
                year = 0;
            }
            try {
                month = Integer.parseInt(this.jTextFieldGregorianMonth.getText()) - 1;
            }
            catch (NumberFormatException nfe) {
                month = 0;
            }
            try {
                day = Integer.parseInt(this.jTextFieldGregorianDay.getText());
            }
            catch (NumberFormatException nfe) {
                day = 0;
            }
            SimplePersianCalendar c = new SimplePersianCalendar();
            c.set(1, year);
            c.set(2, month);
            c.set(5, day);
            DateFields t = c.getDateFields();
            this.jTextFieldPersianYear.setText(Long.toString(t.getYear()));
            this.jTextFieldPersianMonth.setText(Long.toString(t.getMonth() + 1));
            this.jTextFieldPersianDay.setText(Long.toString(t.getDay()));
            this.setPersianText(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertPersianToGregorian() {
        try {
            int day;
            int month;
            int year;
            try {
                year = Integer.parseInt(this.jTextFieldPersianYear.getText());
            }
            catch (NumberFormatException nfe) {
                year = 0;
            }
            try {
                month = Integer.parseInt(this.jTextFieldPersianMonth.getText()) - 1;
            }
            catch (NumberFormatException nfe) {
                month = 0;
            }
            try {
                day = Integer.parseInt(this.jTextFieldPersianDay.getText());
            }
            catch (NumberFormatException nfe) {
                day = 0;
            }
            SimplePersianCalendar c = new SimplePersianCalendar();
            c.setDateFields(year, month, day);
            this.jTextFieldGregorianYear.setText(Long.toString(c.get(0) == 1 ? (long)c.get(1) : (long)(-(c.get(1) - 1))));
            this.jTextFieldGregorianMonth.setText(Long.toString(c.get(2) + 1));
            this.jTextFieldGregorianDay.setText(Long.toString(c.get(5)));
            this.setPersianText(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCurrentDate() {
        SimplePersianCalendar c = new SimplePersianCalendar();
        DateFields t = c.getDateFields();
        this.jTextFieldPersianYear.setText(Long.toString(t.getYear()));
        this.jTextFieldPersianMonth.setText(Long.toString(t.getMonth() + 1));
        this.jTextFieldPersianDay.setText(Long.toString(t.getDay()));
        this.convertPersianToGregorian();
    }

    private void setPersianText(SimplePersianCalendar c) {
        DateFields t = c.getDateFields();
        this.jTextFieldPersianText.setText(SimplePersianCalendar.getPersianWeekDayName(c.get(7)) + "i " + t.getDay() + " " + SimplePersianCalendar.getPersianMonthName(t.getMonth()) + " " + t.getYear());
    }
}

