/*
 * Decompiled with CFR 0.152.
 */
package com.ghasemkiani.util;

import com.ghasemkiani.util.DateFields;
import com.ghasemkiani.util.PersianCalendarConstants;
import com.ghasemkiani.util.PersianCalendarHelper;
import com.ghasemkiani.util.PersianCalendarUtils;
import java.util.GregorianCalendar;

public class SimplePersianCalendar
extends GregorianCalendar
implements PersianCalendarConstants {
    private static String copyright = "Copyright \u00a9 2003-2005 Ghasem Kiani <ghasemkiani@yahoo.com>. All Rights Reserved.";
    private static final long JULIAN_EPOCH_MILLIS = -210866803200000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    public static final String[] persianMonths = new String[]{"\u0641\u0631\u0648\u0631\u062f\u06cc\u0646", "\u0627\u0631\u062f\u06cc\u200c\u0628\u0647\u0634\u062a", "\u062e\u0631\u062f\u0627\u062f", "\u062a\u06cc\u0631", "\u0645\u0631\u062f\u0627\u062f", "\u0634\u0647\u0631\u06cc\u0648\u0631", "\u0645\u0647\u0631", "\u0622\u0628\u0627\u0646", "\u0622\u0630\u0631", "\u062f\u06cc", "\u0628\u0647\u0645\u0646", "\u0627\u0633\u0641\u0646\u062f"};
    public static final String[] persianWeekDays = new String[]{"\u0634\u0646\u0628\u0647", "\u06cc\u06a9\u200c\u0634\u0646\u0628\u0647", "\u062f\u0648\u0634\u0646\u0628\u0647", "\u0633\u0647\u200c\u0634\u0646\u0628\u0647", "\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647", "\u067e\u0646\u062c\u200c\u0634\u0646\u0628\u0647", "\u062c\u0645\u0639\u0647"};

    public long getJulianDay() {
        return PersianCalendarUtils.div(this.getTimeInMillis() - -210866803200000L, 8.64E7);
    }

    public void setJulianDay(long julianDay) {
        this.setTimeInMillis(-210866803200000L + julianDay * 86400000L + PersianCalendarUtils.mod(this.getTimeInMillis() - -210866803200000L, 8.64E7));
    }

    public void setDateFields(int year, int month, int day) {
        this.setDateFields(new DateFields(year, month, day));
    }

    public void setDateFields(DateFields dateFields) {
        int y = dateFields.getYear();
        int m = dateFields.getMonth();
        int d = dateFields.getDay();
        this.setJulianDay(PersianCalendarHelper.pj(y > 0 ? (long)y : (long)(y + 1), m, d));
    }

    public DateFields getDateFields() {
        long julianDay = this.getJulianDay();
        long r = PersianCalendarHelper.jp(julianDay);
        long y = PersianCalendarUtils.y(r);
        int m = PersianCalendarUtils.m(r);
        int d = PersianCalendarUtils.d(r);
        return new DateFields((int)(y > 0L ? y : y - 1L), m, d);
    }

    public static String getPersianMonthName(int month) {
        return persianMonths[month];
    }

    public String getPersianMonthName() {
        return SimplePersianCalendar.getPersianMonthName(this.getDateFields().getMonth());
    }

    public static String getPersianWeekDayName(int weekDay) {
        switch (weekDay) {
            case 7: {
                return persianWeekDays[0];
            }
            case 1: {
                return persianWeekDays[1];
            }
            case 2: {
                return persianWeekDays[2];
            }
            case 3: {
                return persianWeekDays[3];
            }
            case 4: {
                return persianWeekDays[4];
            }
            case 5: {
                return persianWeekDays[5];
            }
            case 6: {
                return persianWeekDays[6];
            }
        }
        return "";
    }

    public String getPersianWeekDayName() {
        return SimplePersianCalendar.getPersianWeekDayName(this.get(7));
    }
}

