/*
 * Decompiled with CFR 0.152.
 */
package com.ghasemkiani.util.icu;

import com.ghasemkiani.util.PersianCalendarConstants;
import com.ghasemkiani.util.PersianCalendarHelper;
import com.ghasemkiani.util.PersianCalendarUtils;
import com.ghasemkiani.util.icu.PersianDateFormat;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;

public class PersianCalendar
extends Calendar
implements PersianCalendarConstants {
    private static String copyright = "Copyright \u00a9 2005, Ghasem Kiani. All Rights Reserved.";
    public static final int BH = 0;
    public static final int AH = 1;
    private static final int[][] LIMITS = new int[][]{{0, 0, 1, 1}, {1, 1, 5000000, 5000000}, {0, 0, 11, 11}, {1, 1, 51, 52}, {0, 0, 5, 6}, {1, 1, 29, 31}, {1, 1, 365, 366}, new int[0], {-1, -1, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000001, -5000001, 5000001, 5000001}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0]};

    public PersianCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault());
    }

    public PersianCalendar(TimeZone zone) {
        this(zone, ULocale.getDefault());
    }

    public PersianCalendar(Locale aLocale) {
        this(ULocale.forLocale((Locale)aLocale));
    }

    public PersianCalendar(ULocale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public PersianCalendar(TimeZone zone, Locale aLocale) {
        this(zone, ULocale.forLocale((Locale)aLocale));
    }

    public PersianCalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public PersianCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.setTime(date);
    }

    public PersianCalendar(int year, int month, int date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(0, 1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    public PersianCalendar(int year, int month, int date, int hour, int minute, int second) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(0, 1);
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    protected int handleGetMonthLength(int extendedYear, int month) {
        if (month < 6) {
            return 31;
        }
        if (month < 11) {
            return 30;
        }
        return PersianCalendarHelper.isLeapYear(extendedYear) ? 30 : 29;
    }

    protected int handleGetYearLength(int extendedYear) {
        return PersianCalendarHelper.isLeapYear(extendedYear) ? 366 : 365;
    }

    protected int handleComputeMonthStart(int extendedYear, int month, boolean useMonth) {
        return (int)PersianCalendarHelper.pj(extendedYear, month, 0);
    }

    protected int handleGetExtendedYear() {
        int era;
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : ((era = this.internalGet(0, 1)) == 0 ? 1 - this.internalGet(1, 1) : this.internalGet(1, 1));
        return year;
    }

    protected void handleComputeFields(int julianDay) {
        long r = PersianCalendarHelper.jp(julianDay);
        int year = (int)PersianCalendarUtils.y(r);
        int month = PersianCalendarUtils.m(r);
        int day = PersianCalendarUtils.d(r);
        this.internalSet(0, year > 0 ? 1 : 0);
        this.internalSet(1, year > 0 ? year : 1 - year);
        this.internalSet(19, year);
        this.internalSet(2, month);
        this.internalSet(5, day);
        this.internalSet(6, day + month * 30 + Math.min(6, month));
    }

    protected DateFormat handleGetDateFormat(String pattern, ULocale locale) {
        return new PersianDateFormat(pattern, locale);
    }

    public void add(int field, int amount) {
        switch (field) {
            case 2: {
                int month = this.get(2);
                int extendedYear = this.get(19);
                if (amount > 0) {
                    extendedYear += amount / 12;
                    if ((month += amount % 12) > 11) {
                        month -= 12;
                        ++extendedYear;
                    }
                } else {
                    amount = -amount;
                    extendedYear -= amount / 12;
                    if ((month -= amount % 12) < 0) {
                        month += 12;
                        --extendedYear;
                    }
                }
                this.set(19, extendedYear);
                this.set(2, month);
                this.pinField(5);
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
    }

    public String getType() {
        return "persian";
    }
}

