/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * legal/CDDLv1.0.txt or 
 * https://javaserverfaces.dev.java.net/CDDL.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
package com.sun.faces.config;

import java.util.ArrayList;
import java.util.List;

import com.sun.faces.config.beans.ApplicationBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.ConverterBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.FactoryBean;
import com.sun.faces.config.beans.LifecycleBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.config.beans.ValidatorBean;


/*
 * ******* GENERATED CODE - DO NOT EDIT *******
 */


public final class Bootstrapper {

    private FactoryBean factoryBean;
    private ApplicationBean applicationBean;
    private LifecycleBean lifecycleBean;
    private RenderKitBean renderKitBean;
    private List<ConverterBean> converters = new ArrayList<ConverterBean>();
    private List<ValidatorBean> validators = new ArrayList<ValidatorBean>();
    private List<ComponentBean> components = new ArrayList<ComponentBean>();

    public Bootstrapper() {

        factoryBean = new FactoryBean();
        factoryBean.addApplicationFactory("com.sun.faces.application.ApplicationFactoryImpl");
        factoryBean.addFacesContextFactory("com.sun.faces.context.FacesContextFactoryImpl");
        factoryBean.addLifecycleFactory("com.sun.faces.lifecycle.LifecycleFactoryImpl");
        factoryBean.addRenderKitFactory("com.sun.faces.renderkit.RenderKitFactoryImpl");

        applicationBean = new ApplicationBean();
        applicationBean.addActionListener("com.sun.faces.application.ActionListenerImpl");
        applicationBean.addNavigationHandler("com.sun.faces.application.NavigationHandlerImpl");
        applicationBean.addStateManager("com.sun.faces.application.StateManagerImpl");
        applicationBean.addViewHandler("com.sun.faces.application.ViewHandlerImpl");

        lifecycleBean = new LifecycleBean();
        lifecycleBean.addPhaseListener("com.sun.faces.lifecycle.ELResolverInitPhaseListener");

        /*
         * Wrap these in braces to allow repetition of the ivar name
         */
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.BigDecimal");
            converter.setConverterClass("javax.faces.convert.BigDecimalConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.BigInteger");
            converter.setConverterClass("javax.faces.convert.BigIntegerConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Boolean");
            converter.setConverterClass("javax.faces.convert.BooleanConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Byte");
            converter.setConverterClass("javax.faces.convert.ByteConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Character");
            converter.setConverterClass("javax.faces.convert.CharacterConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.DateTime");
            converter.setConverterClass("javax.faces.convert.DateTimeConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Double");
            converter.setConverterClass("javax.faces.convert.DoubleConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Float");
            converter.setConverterClass("javax.faces.convert.FloatConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Integer");
            converter.setConverterClass("javax.faces.convert.IntegerConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Long");
            converter.setConverterClass("javax.faces.convert.LongConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Number");
            converter.setConverterClass("javax.faces.convert.NumberConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterId("javax.faces.Short");
            converter.setConverterClass("javax.faces.convert.ShortConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.math.BigDecimal.class);
            converter.setConverterClass("javax.faces.convert.BigDecimalConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.math.BigInteger.class);
            converter.setConverterClass("javax.faces.convert.BigIntegerConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Boolean.class);
            converter.setConverterClass("javax.faces.convert.BooleanConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Byte.class);
            converter.setConverterClass("javax.faces.convert.ByteConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Character.class);
            converter.setConverterClass("javax.faces.convert.CharacterConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Double.class);
            converter.setConverterClass("javax.faces.convert.DoubleConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Float.class);
            converter.setConverterClass("javax.faces.convert.FloatConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Integer.class);
            converter.setConverterClass("javax.faces.convert.IntegerConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Long.class);
            converter.setConverterClass("javax.faces.convert.LongConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Short.class);
            converter.setConverterClass("javax.faces.convert.ShortConverter");
            converters.add(converter);
        }
        {
            ConverterBean converter = new ConverterBean();
            converter.setConverterForClass(java.lang.Enum.class);
            converter.setConverterClass("javax.faces.convert.EnumConverter");
            converters.add(converter);
        }

        /*
         * Wrap these in braces to allow repetition of the ivar name
         */
        {
            ValidatorBean validator = new ValidatorBean();
            validator.setValidatorId("javax.faces.DoubleRange");
            validator.setValidatorClass("javax.faces.validator.DoubleRangeValidator");
            validators.add(validator);
        }
        {
            ValidatorBean validator = new ValidatorBean();
            validator.setValidatorId("javax.faces.Length");
            validator.setValidatorClass("javax.faces.validator.LengthValidator");
            validators.add(validator);
        }
        {
            ValidatorBean validator = new ValidatorBean();
            validator.setValidatorId("javax.faces.LongRange");
            validator.setValidatorClass("javax.faces.validator.LongRangeValidator");
            validators.add(validator);
        }

        /*
         * Wrap these in braces to allow repetition of the ivar name
         */
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Column");
            component.setComponentClass("javax.faces.component.UIColumn");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Command");
            component.setComponentClass("javax.faces.component.UICommand");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Data");
            component.setComponentClass("javax.faces.component.UIData");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Form");
            component.setComponentClass("javax.faces.component.UIForm");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Graphic");
            component.setComponentClass("javax.faces.component.UIGraphic");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Input");
            component.setComponentClass("javax.faces.component.UIInput");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Message");
            component.setComponentClass("javax.faces.component.UIMessage");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Messages");
            component.setComponentClass("javax.faces.component.UIMessages");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.NamingContainer");
            component.setComponentClass("javax.faces.component.UINamingContainer");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Output");
            component.setComponentClass("javax.faces.component.UIOutput");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Panel");
            component.setComponentClass("javax.faces.component.UIPanel");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.Parameter");
            component.setComponentClass("javax.faces.component.UIParameter");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.SelectBoolean");
            component.setComponentClass("javax.faces.component.UISelectBoolean");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.SelectItem");
            component.setComponentClass("javax.faces.component.UISelectItem");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.SelectItems");
            component.setComponentClass("javax.faces.component.UISelectItems");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.SelectMany");
            component.setComponentClass("javax.faces.component.UISelectMany");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.SelectOne");
            component.setComponentClass("javax.faces.component.UISelectOne");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.ViewRoot");
            component.setComponentClass("javax.faces.component.UIViewRoot");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlColumn");
            component.setComponentClass("javax.faces.component.html.HtmlColumn");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlCommandButton");
            component.setComponentClass("javax.faces.component.html.HtmlCommandButton");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlCommandLink");
            component.setComponentClass("javax.faces.component.html.HtmlCommandLink");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlDataTable");
            component.setComponentClass("javax.faces.component.html.HtmlDataTable");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlForm");
            component.setComponentClass("javax.faces.component.html.HtmlForm");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlGraphicImage");
            component.setComponentClass("javax.faces.component.html.HtmlGraphicImage");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlInputHidden");
            component.setComponentClass("javax.faces.component.html.HtmlInputHidden");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlInputSecret");
            component.setComponentClass("javax.faces.component.html.HtmlInputSecret");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlInputText");
            component.setComponentClass("javax.faces.component.html.HtmlInputText");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlInputTextarea");
            component.setComponentClass("javax.faces.component.html.HtmlInputTextarea");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlMessage");
            component.setComponentClass("javax.faces.component.html.HtmlMessage");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlMessages");
            component.setComponentClass("javax.faces.component.html.HtmlMessages");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlOutputFormat");
            component.setComponentClass("javax.faces.component.html.HtmlOutputFormat");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlOutputLabel");
            component.setComponentClass("javax.faces.component.html.HtmlOutputLabel");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlOutputLink");
            component.setComponentClass("javax.faces.component.html.HtmlOutputLink");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlOutputText");
            component.setComponentClass("javax.faces.component.html.HtmlOutputText");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlPanelGrid");
            component.setComponentClass("javax.faces.component.html.HtmlPanelGrid");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlPanelGroup");
            component.setComponentClass("javax.faces.component.html.HtmlPanelGroup");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectBooleanCheckbox");
            component.setComponentClass("javax.faces.component.html.HtmlSelectBooleanCheckbox");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectManyCheckbox");
            component.setComponentClass("javax.faces.component.html.HtmlSelectManyCheckbox");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectManyListbox");
            component.setComponentClass("javax.faces.component.html.HtmlSelectManyListbox");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectManyMenu");
            component.setComponentClass("javax.faces.component.html.HtmlSelectManyMenu");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectOneListbox");
            component.setComponentClass("javax.faces.component.html.HtmlSelectOneListbox");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectOneMenu");
            component.setComponentClass("javax.faces.component.html.HtmlSelectOneMenu");
            components.add(component);
        }
        {
            ComponentBean component = new ComponentBean();
            component.setComponentType("javax.faces.HtmlSelectOneRadio");
            component.setComponentClass("javax.faces.component.html.HtmlSelectOneRadio");
            components.add(component);
        }

        renderKitBean = new RenderKitBean();
        /*
         * Wrap these in braces to allow repetition of the ivar name
         */
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Command");
            rendererBean.setRendererType("javax.faces.Button");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.ButtonRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Command");
            rendererBean.setRendererType("javax.faces.Link");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.CommandLinkRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Data");
            rendererBean.setRendererType("javax.faces.Table");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.TableRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Form");
            rendererBean.setRendererType("javax.faces.Form");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.FormRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Graphic");
            rendererBean.setRendererType("javax.faces.Image");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.ImageRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Input");
            rendererBean.setRendererType("javax.faces.Hidden");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.HiddenRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Input");
            rendererBean.setRendererType("javax.faces.Secret");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.SecretRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Input");
            rendererBean.setRendererType("javax.faces.Text");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.TextRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Input");
            rendererBean.setRendererType("javax.faces.Textarea");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.TextareaRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Message");
            rendererBean.setRendererType("javax.faces.Message");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.MessageRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Messages");
            rendererBean.setRendererType("javax.faces.Messages");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.MessagesRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Output");
            rendererBean.setRendererType("javax.faces.Format");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.OutputMessageRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Output");
            rendererBean.setRendererType("javax.faces.Label");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.LabelRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Output");
            rendererBean.setRendererType("javax.faces.Link");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.OutputLinkRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Output");
            rendererBean.setRendererType("javax.faces.Text");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.TextRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Panel");
            rendererBean.setRendererType("javax.faces.Grid");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.GridRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.Panel");
            rendererBean.setRendererType("javax.faces.Group");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.GroupRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectBoolean");
            rendererBean.setRendererType("javax.faces.Checkbox");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.CheckboxRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectMany");
            rendererBean.setRendererType("javax.faces.Checkbox");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.SelectManyCheckboxListRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectMany");
            rendererBean.setRendererType("javax.faces.Listbox");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.ListboxRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectMany");
            rendererBean.setRendererType("javax.faces.Menu");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.MenuRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectOne");
            rendererBean.setRendererType("javax.faces.Listbox");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.ListboxRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectOne");
            rendererBean.setRendererType("javax.faces.Menu");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.MenuRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
        {
            RendererBean rendererBean = new RendererBean();
            rendererBean.setComponentFamily("javax.faces.SelectOne");
            rendererBean.setRendererType("javax.faces.Radio");
            rendererBean.setRendererClass("com.sun.faces.renderkit.html_basic.RadioRenderer");
            renderKitBean.addRenderer(rendererBean);
        }
    }

    public void populateFacesConfigBean(FacesConfigBean fcb) {
        fcb.setFactory(factoryBean);
        fcb.setApplication(applicationBean);
        fcb.setLifecycle(lifecycleBean);
        fcb.addRenderKit(renderKitBean);
        for (ComponentBean component : components) {
            fcb.addComponent(component);
        }
        for (ConverterBean converter : converters) {
            fcb.addConverter(converter);
        }
        for (ValidatorBean validator : validators) {
            fcb.addValidator(validator);
        }
    }
}
