/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import java.io.IOException;
import java.util.ListIterator;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.AjaxBehavior;
import javax.faces.component.AjaxBehaviors;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.pdl.facelets.FaceletContext;
import javax.faces.webapp.pdl.facelets.FaceletException;
import javax.faces.webapp.pdl.facelets.tag.TagAttribute;
import javax.faces.webapp.pdl.facelets.tag.TagAttributeException;
import javax.faces.webapp.pdl.facelets.tag.TagConfig;

public final class AjaxHandler
extends TagHandlerImpl {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute onevent = this.getAttribute("onevent");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute disabled = this.getAttribute("disabled");

    public AjaxHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (null == parent || !ComponentSupport.isNew(parent)) {
            return;
        }
        String event = this.event != null ? this.event.getValue() : null;
        AjaxBehavior ajaxBehavior = new AjaxBehavior(event, this.onevent != null ? this.onevent.getValueExpression(ctx, String.class) : null, this.onerror != null ? this.onerror.getValueExpression(ctx, String.class) : null, this.execute != null ? this.execute.getValueExpression(ctx, Object.class) : null, this.render != null ? this.render.getValueExpression(ctx, Object.class) : null, this.disabled != null ? this.disabled.getValueExpression(ctx, Boolean.class) : null);
        if (parent instanceof ActionSource) {
            if (null == event || event.equals("all") || event.equals("action")) {
                parent.getAttributes().put("javax.faces.component.AjaxBehavior", ajaxBehavior);
                this.installAjaxResourceIfNecessary();
                return;
            }
            throw new TagAttributeException(this.event, "'event' attribute value must be 'action' for 'ActionSource' components");
        }
        if (parent instanceof EditableValueHolder) {
            if (null == event || event.equals("all") || event.equals("valueChange")) {
                parent.getAttributes().put("javax.faces.component.AjaxBehavior", ajaxBehavior);
                this.installAjaxResourceIfNecessary();
                return;
            }
            throw new TagAttributeException(this.event, "'event' attribute value must be 'valueChange' for 'EditableValueHolder' components");
        }
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)ctx.getFacesContext().getAttributes().get("javax.faces.component.AjaxBehaviors");
        if (ajaxBehaviors == null) {
            ajaxBehaviors = new AjaxBehaviors();
        }
        ajaxBehaviors.pushBehavior(ajaxBehavior);
        ctx.getFacesContext().getAttributes().put("javax.faces.component.AjaxBehaviors", ajaxBehaviors);
        this.installAjaxResourceIfNecessary();
        this.nextHandler.apply(ctx, parent);
        FacesContext context = ctx.getFacesContext();
        ajaxBehaviors = (AjaxBehaviors)context.getAttributes().get("javax.faces.component.AjaxBehaviors");
        if (ajaxBehaviors != null) {
            ajaxBehaviors.popBehavior();
        }
    }

    private void installAjaxResourceIfNecessary() {
        String rlibrary;
        String rname;
        UIComponent resource;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getAttributes().get("com.sun.faces.jsfjsState") != null) {
            return;
        }
        String name = "jsf.js";
        String library = "javax.faces";
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "head").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "body").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        iter = viewRoot.getComponentResources(context, "form").listIterator();
        while (iter.hasNext()) {
            resource = (UIComponent)iter.next();
            rname = (String)resource.getAttributes().get("name");
            rlibrary = (String)resource.getAttributes().get("library");
            if (!"jsf.js".equals(rname) || !"javax.faces".equals(rlibrary)) continue;
            context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
            return;
        }
        UIOutput output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        output.getAttributes().put("name", "jsf.js");
        output.getAttributes().put("library", "javax.faces");
        viewRoot.addComponentResource(context, (UIComponent)output, "head");
        context.getAttributes().put("com.sun.faces.jsfjsState", Boolean.TRUE);
    }
}

