/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jstl.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.webapp.pdl.facelets.FaceletContext;
import javax.faces.webapp.pdl.facelets.FaceletException;
import javax.faces.webapp.pdl.facelets.tag.TagAttribute;
import javax.faces.webapp.pdl.facelets.tag.TagConfig;
import javax.faces.webapp.pdl.facelets.tag.TagException;

public class SetHandler
extends TagHandlerImpl {
    private final TagAttribute var;
    private final TagAttribute value = this.getAttribute("value");
    private final TagAttribute target;
    private final TagAttribute property;
    private final TagAttribute scope;

    public SetHandler(TagConfig config) {
        super(config);
        this.var = this.getAttribute("var");
        this.target = this.getAttribute("target");
        this.property = this.getAttribute("property");
        this.scope = this.getAttribute("scope");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (null != this.var && (null == this.value || 0 == this.value.getValue().length())) {
            throw new TagException(this.tag, "var set with null or empty value");
        }
        ValueExpression veObj = this.value.getValueExpression(ctx, Object.class);
        if (null != this.var) {
            String varStr = this.var.getValue(ctx);
            if (null != this.scope) {
                if (0 == this.scope.getValue().length()) {
                    throw new TagException(this.tag, "zero length scope attribute set");
                }
                String scopeStr = this.scope.isLiteral() ? this.scope.getValue() : this.scope.getValue(ctx);
                if (scopeStr.equals("page")) {
                    throw new TagException(this.tag, "page scope does not exist in JSF, consider using view scope instead.");
                }
                if (scopeStr.equals("request") || scopeStr.equals("session") || scopeStr.equals("application") || scopeStr.equals("view")) {
                    scopeStr = scopeStr + "Scope";
                }
                String expr = "#{" + scopeStr + "." + varStr + "}";
                ValueExpression lhs = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, expr, Object.class);
                lhs.setValue((ELContext)ctx, veObj.getValue((ELContext)ctx));
            } else {
                ctx.getVariableMapper().setVariable(varStr, veObj);
            }
        } else {
            assert (null == this.var);
            if (null == this.target || null == this.target.getValue() || this.target.getValue().length() <= 0 || null == this.property || null == this.property.getValue() || this.property.getValue().length() <= 0 || null == this.value || null == this.value.getValue() || this.value.getValue().length() <= 0) {
                throw new TagException(this.tag, "when using this tag either one of var and value, or (target, property, value) must be set.");
            }
            if (this.target.isLiteral()) {
                throw new TagException(this.tag, "value of target attribute must be an expression");
            }
            String propertyStr = null;
            propertyStr = this.property.isLiteral() ? this.property.getValue() : this.property.getValue(ctx);
            ValueExpression targetVe = this.target.getValueExpression(ctx, Object.class);
            Object targetValue = targetVe.getValue((ELContext)ctx);
            ctx.getFacesContext().getELContext().getELResolver().setValue((ELContext)ctx, targetValue, (Object)propertyStr, veObj.getValue((ELContext)ctx));
        }
    }
}

