/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.regexp.internal;

import com.sun.org.apache.regexp.internal.CharacterIterator;
import com.sun.org.apache.regexp.internal.RECompiler;
import com.sun.org.apache.regexp.internal.REProgram;
import com.sun.org.apache.regexp.internal.RESyntaxException;
import com.sun.org.apache.regexp.internal.StringCharacterIterator;
import java.util.Vector;

public class RE {
    public static final int MATCH_NORMAL = 0;
    public static final int MATCH_CASEINDEPENDENT = 1;
    public static final int MATCH_MULTILINE = 2;
    public static final int MATCH_SINGLELINE = 4;
    static final char OP_END = 'E';
    static final char OP_BOL = '^';
    static final char OP_EOL = '$';
    static final char OP_ANY = '.';
    static final char OP_ANYOF = '[';
    static final char OP_BRANCH = '|';
    static final char OP_ATOM = 'A';
    static final char OP_STAR = '*';
    static final char OP_PLUS = '+';
    static final char OP_MAYBE = '?';
    static final char OP_ESCAPE = '\\';
    static final char OP_OPEN = '(';
    static final char OP_CLOSE = ')';
    static final char OP_BACKREF = '#';
    static final char OP_GOTO = 'G';
    static final char OP_NOTHING = 'N';
    static final char OP_RELUCTANTSTAR = '8';
    static final char OP_RELUCTANTPLUS = '=';
    static final char OP_RELUCTANTMAYBE = '/';
    static final char OP_POSIXCLASS = 'P';
    static final char E_ALNUM = 'w';
    static final char E_NALNUM = 'W';
    static final char E_BOUND = 'b';
    static final char E_NBOUND = 'B';
    static final char E_SPACE = 's';
    static final char E_NSPACE = 'S';
    static final char E_DIGIT = 'd';
    static final char E_NDIGIT = 'D';
    static final char POSIX_CLASS_ALNUM = 'w';
    static final char POSIX_CLASS_ALPHA = 'a';
    static final char POSIX_CLASS_BLANK = 'b';
    static final char POSIX_CLASS_CNTRL = 'c';
    static final char POSIX_CLASS_DIGIT = 'd';
    static final char POSIX_CLASS_GRAPH = 'g';
    static final char POSIX_CLASS_LOWER = 'l';
    static final char POSIX_CLASS_PRINT = 'p';
    static final char POSIX_CLASS_PUNCT = '!';
    static final char POSIX_CLASS_SPACE = 's';
    static final char POSIX_CLASS_UPPER = 'u';
    static final char POSIX_CLASS_XDIGIT = 'x';
    static final char POSIX_CLASS_JSTART = 'j';
    static final char POSIX_CLASS_JPART = 'k';
    static final int maxNode = 65536;
    static final int maxParen = 16;
    static final int offsetOpcode = 0;
    static final int offsetOpdata = 1;
    static final int offsetNext = 2;
    static final int nodeSize = 3;
    static final String NEWLINE = System.getProperty("line.separator");
    REProgram program;
    CharacterIterator search;
    int idx;
    int matchFlags;
    int parenCount;
    int start0;
    int end0;
    int start1;
    int end1;
    int start2;
    int end2;
    int[] startn;
    int[] endn;
    int[] startBackref;
    int[] endBackref;
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE_FIRSTONLY = 1;

    public RE(String pattern) throws RESyntaxException {
        this(pattern, 0);
    }

    public RE(String pattern, int matchFlags) throws RESyntaxException {
        this(new RECompiler().compile(pattern));
        this.setMatchFlags(matchFlags);
    }

    public RE(REProgram program, int matchFlags) {
        this.setProgram(program);
        this.setMatchFlags(matchFlags);
    }

    public RE(REProgram program) {
        this(program, 0);
    }

    public RE() {
        this((REProgram)null, 0);
    }

    public static String simplePatternToFullRegularExpression(String pattern) {
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    buf.append(".*");
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buf.append('\\');
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public void setMatchFlags(int matchFlags) {
        this.matchFlags = matchFlags;
    }

    public int getMatchFlags() {
        return this.matchFlags;
    }

    public void setProgram(REProgram program) {
        this.program = program;
    }

    public REProgram getProgram() {
        return this.program;
    }

    public int getParenCount() {
        return this.parenCount;
    }

    public String getParen(int which) {
        int start;
        if (which < this.parenCount && (start = this.getParenStart(which)) >= 0) {
            return this.search.substring(start, this.getParenEnd(which));
        }
        return null;
    }

    public final int getParenStart(int which) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    return this.start0;
                }
                case 1: {
                    return this.start1;
                }
                case 2: {
                    return this.start2;
                }
            }
            if (this.startn == null) {
                this.allocParens();
            }
            return this.startn[which];
        }
        return -1;
    }

    public final int getParenEnd(int which) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    return this.end0;
                }
                case 1: {
                    return this.end1;
                }
                case 2: {
                    return this.end2;
                }
            }
            if (this.endn == null) {
                this.allocParens();
            }
            return this.endn[which];
        }
        return -1;
    }

    public final int getParenLength(int which) {
        if (which < this.parenCount) {
            return this.getParenEnd(which) - this.getParenStart(which);
        }
        return -1;
    }

    protected final void setParenStart(int which, int i) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    this.start0 = i;
                    break;
                }
                case 1: {
                    this.start1 = i;
                    break;
                }
                case 2: {
                    this.start2 = i;
                    break;
                }
                default: {
                    if (this.startn == null) {
                        this.allocParens();
                    }
                    this.startn[which] = i;
                }
            }
        }
    }

    protected final void setParenEnd(int which, int i) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    this.end0 = i;
                    break;
                }
                case 1: {
                    this.end1 = i;
                    break;
                }
                case 2: {
                    this.end2 = i;
                    break;
                }
                default: {
                    if (this.endn == null) {
                        this.allocParens();
                    }
                    this.endn[which] = i;
                }
            }
        }
    }

    protected void internalError(String s) throws Error {
        throw new Error("RE internal error: " + s);
    }

    private final void allocParens() {
        this.startn = new int[16];
        this.endn = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.startn[i] = -1;
            this.endn[i] = -1;
        }
    }

    protected int matchNodes(int firstNode, int lastNode, int idxStart) {
        int idx = idxStart;
        char[] instruction = this.program.instruction;
        int node = firstNode;
        block49: while (node < lastNode) {
            char opcode = instruction[node + 0];
            int next = node + (short)instruction[node + 2];
            int opdata = instruction[node + 1];
            block0 : switch (opcode) {
                case '/': {
                    int once = 0;
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(next, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while (once++ == 0 && (idx = this.matchNodes(node + 3, next, idx)) != -1);
                    return -1;
                }
                case '=': {
                    while ((idx = this.matchNodes(node + 3, next, idx)) != -1) {
                        int idxNew = this.matchNodes(next, 65536, idx);
                        if (idxNew == -1) continue;
                        return idxNew;
                    }
                    return -1;
                }
                case '8': {
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(next, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while ((idx = this.matchNodes(node + 3, next, idx)) != -1);
                    return -1;
                }
                case '(': {
                    int idxNew;
                    if ((this.program.flags & 1) != 0) {
                        this.startBackref[opdata] = idx;
                    }
                    if ((idxNew = this.matchNodes(next, 65536, idx)) != -1) {
                        if (opdata + '\u0001' > this.parenCount) {
                            this.parenCount = opdata + '\u0001';
                        }
                        if (this.getParenStart(opdata) == -1) {
                            this.setParenStart(opdata, idx);
                        }
                    }
                    return idxNew;
                }
                case ')': {
                    int idxNew;
                    if ((this.program.flags & 1) != 0) {
                        this.endBackref[opdata] = idx;
                    }
                    if ((idxNew = this.matchNodes(next, 65536, idx)) != -1) {
                        if (opdata + '\u0001' > this.parenCount) {
                            this.parenCount = opdata + '\u0001';
                        }
                        if (this.getParenEnd(opdata) == -1) {
                            this.setParenEnd(opdata, idx);
                        }
                    }
                    return idxNew;
                }
                case '#': {
                    int i;
                    int s = this.startBackref[opdata];
                    int e = this.endBackref[opdata];
                    if (s == -1 || e == -1) {
                        return -1;
                    }
                    if (s == e) break;
                    int l = e - s;
                    if (this.search.isEnd(idx + l - 1)) {
                        return -1;
                    }
                    if ((this.matchFlags & 1) != 0) {
                        for (i = 0; i < l; ++i) {
                            if (Character.toLowerCase(this.search.charAt(idx++)) == Character.toLowerCase(this.search.charAt(s + i))) continue;
                            return -1;
                        }
                    } else {
                        for (i = 0; i < l; ++i) {
                            if (this.search.charAt(idx++) == this.search.charAt(s + i)) continue;
                            return -1;
                        }
                    }
                    break;
                }
                case '^': {
                    if (idx == 0) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (idx > 0 && this.isNewline(idx - 1)) break;
                        return -1;
                    }
                    return -1;
                }
                case '$': {
                    if (this.search.isEnd(0) || this.search.isEnd(idx)) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (this.isNewline(idx)) break;
                        return -1;
                    }
                    return -1;
                }
                case '\\': {
                    switch (opdata) {
                        case 66: 
                        case 98: {
                            char cLast = idx == this.getParenStart(0) ? (char)'\n' : (char)this.search.charAt(idx - 1);
                            char cNext = this.search.isEnd(idx) ? (char)'\n' : (char)this.search.charAt(idx);
                            if (Character.isLetterOrDigit(cLast) == Character.isLetterOrDigit(cNext) != (opdata == 98)) break block0;
                            return -1;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 100: 
                        case 115: 
                        case 119: {
                            if (this.search.isEnd(idx)) {
                                return -1;
                            }
                            switch (opdata) {
                                case 87: 
                                case 119: {
                                    if (Character.isLetterOrDigit(this.search.charAt(idx)) == (opdata == 119)) break;
                                    return -1;
                                }
                                case 68: 
                                case 100: {
                                    if (Character.isDigit(this.search.charAt(idx)) == (opdata == 100)) break;
                                    return -1;
                                }
                                case 83: 
                                case 115: {
                                    if (Character.isWhitespace(this.search.charAt(idx)) == (opdata == 115)) break;
                                    return -1;
                                }
                            }
                            ++idx;
                            break;
                        }
                        default: {
                            this.internalError("Unrecognized escape '" + opdata + "'");
                            break;
                        }
                    }
                    break;
                }
                case '.': {
                    if ((this.matchFlags & 4) == 4) {
                        if (this.search.isEnd(idx)) {
                            return -1;
                        }
                        ++idx;
                        break;
                    }
                    if (!this.search.isEnd(idx) && this.search.charAt(idx++) != '\n') break;
                    return -1;
                }
                case 'A': {
                    int i;
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    int lenAtom = opdata;
                    int startAtom = node + 3;
                    if (this.search.isEnd(lenAtom + idx - 1)) {
                        return -1;
                    }
                    if ((this.matchFlags & 1) != 0) {
                        for (i = 0; i < lenAtom; ++i) {
                            if (Character.toLowerCase(this.search.charAt(idx++)) == Character.toLowerCase(instruction[startAtom + i])) continue;
                            return -1;
                        }
                    } else {
                        for (i = 0; i < lenAtom; ++i) {
                            if (this.search.charAt(idx++) == instruction[startAtom + i]) continue;
                            return -1;
                        }
                    }
                    break;
                }
                case 'P': {
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    block27 : switch (opdata) {
                        case 119: {
                            if (Character.isLetterOrDigit(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 97: {
                            if (Character.isLetter(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 100: {
                            if (Character.isDigit(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 98: {
                            if (Character.isSpaceChar(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 115: {
                            if (Character.isWhitespace(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 99: {
                            if (Character.getType(this.search.charAt(idx)) == 15) break;
                            return -1;
                        }
                        case 103: {
                            switch (Character.getType(this.search.charAt(idx))) {
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: {
                                    break block27;
                                }
                            }
                            return -1;
                        }
                        case 108: {
                            if (Character.getType(this.search.charAt(idx)) == 2) break;
                            return -1;
                        }
                        case 117: {
                            if (Character.getType(this.search.charAt(idx)) == 1) break;
                            return -1;
                        }
                        case 112: {
                            if (Character.getType(this.search.charAt(idx)) != 15) break;
                            return -1;
                        }
                        case 33: {
                            int type = Character.getType(this.search.charAt(idx));
                            switch (type) {
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    break block27;
                                }
                            }
                            return -1;
                        }
                        case 120: {
                            boolean isXDigit;
                            boolean bl = isXDigit = this.search.charAt(idx) >= '0' && this.search.charAt(idx) <= '9' || this.search.charAt(idx) >= 'a' && this.search.charAt(idx) <= 'f' || this.search.charAt(idx) >= 'A' && this.search.charAt(idx) <= 'F';
                            if (isXDigit) break;
                            return -1;
                        }
                        case 106: {
                            if (Character.isJavaIdentifierStart(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 107: {
                            if (Character.isJavaIdentifierPart(this.search.charAt(idx))) break;
                            return -1;
                        }
                        default: {
                            this.internalError("Bad posix class");
                        }
                    }
                    ++idx;
                    break;
                }
                case '[': {
                    boolean caseFold;
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    char c = this.search.charAt(idx);
                    boolean bl = caseFold = (this.matchFlags & 1) != 0;
                    if (caseFold) {
                        c = Character.toLowerCase(c);
                    }
                    int idxRange = node + 3;
                    int idxEnd = idxRange + opdata * 2;
                    boolean match = false;
                    int i = idxRange;
                    while (i < idxEnd) {
                        char s = instruction[i++];
                        char e = instruction[i++];
                        if (caseFold) {
                            s = Character.toLowerCase(s);
                            e = Character.toLowerCase(e);
                        }
                        if (c < s || c > e) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        return -1;
                    }
                    ++idx;
                    break;
                }
                case '|': {
                    short nextBranch;
                    if (instruction[next + 0] != '|') {
                        node += 3;
                        continue block49;
                    }
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(node + 3, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while ((nextBranch = (short)instruction[node + 2]) != 0 && instruction[(node += nextBranch) + 0] == '|');
                    return -1;
                }
                case 'G': 
                case 'N': {
                    break;
                }
                case 'E': {
                    this.setParenEnd(0, idx);
                    return idx;
                }
                default: {
                    this.internalError("Invalid opcode '" + opcode + "'");
                }
            }
            node = next;
        }
        this.internalError("Corrupt program");
        return -1;
    }

    protected boolean matchAt(int i) {
        int idx;
        this.start0 = -1;
        this.end0 = -1;
        this.start1 = -1;
        this.end1 = -1;
        this.start2 = -1;
        this.end2 = -1;
        this.startn = null;
        this.endn = null;
        this.parenCount = 1;
        this.setParenStart(0, i);
        if ((this.program.flags & 1) != 0) {
            this.startBackref = new int[16];
            this.endBackref = new int[16];
        }
        if ((idx = this.matchNodes(0, 65536, i)) != -1) {
            this.setParenEnd(0, idx);
            return true;
        }
        this.parenCount = 0;
        return false;
    }

    public boolean match(String search, int i) {
        return this.match(new StringCharacterIterator(search), i);
    }

    public boolean match(CharacterIterator search, int i) {
        if (this.program == null) {
            this.internalError("No RE program to run!");
        }
        this.search = search;
        if (this.program.prefix == null) {
            while (!search.isEnd(i - 1)) {
                if (this.matchAt(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        boolean caseIndependent = (this.matchFlags & 1) != 0;
        char[] prefix = this.program.prefix;
        while (!search.isEnd(i + prefix.length - 1)) {
            boolean match = false;
            if (caseIndependent) {
                match = Character.toLowerCase(search.charAt(i)) == Character.toLowerCase(prefix[0]);
            } else {
                boolean bl = match = search.charAt(i) == prefix[0];
            }
            if (match) {
                int firstChar = i++;
                int k = 1;
                while (k < prefix.length) {
                    if (caseIndependent) {
                        match = Character.toLowerCase(search.charAt(i++)) == Character.toLowerCase(prefix[k++]);
                    } else {
                        boolean bl = match = search.charAt(i++) == prefix[k++];
                    }
                    if (match) continue;
                }
                if (k == prefix.length && this.matchAt(firstChar)) {
                    return true;
                }
                i = firstChar;
            }
            ++i;
        }
        return false;
    }

    public boolean match(String search) {
        return this.match(search, 0);
    }

    public String[] split(String s) {
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int len = s.length();
        while (pos < len && this.match(s, pos)) {
            int start = this.getParenStart(0);
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                v.addElement(s.substring(pos, start + 1));
            } else {
                v.addElement(s.substring(pos, start));
            }
            pos = ++newpos;
        }
        String remainder = s.substring(pos);
        if (remainder.length() != 0) {
            v.addElement(remainder);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public String subst(String substituteIn, String substitution) {
        return this.subst(substituteIn, substitution, 0);
    }

    public String subst(String substituteIn, String substitution, int flags) {
        StringBuffer ret = new StringBuffer();
        int pos = 0;
        int len = substituteIn.length();
        while (pos < len && this.match(substituteIn, pos)) {
            ret.append(substituteIn.substring(pos, this.getParenStart(0)));
            ret.append(substitution);
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                // empty if block
            }
            pos = ++newpos;
            if ((flags & 1) == 0) continue;
            break;
        }
        if (pos < len) {
            ret.append(substituteIn.substring(pos));
        }
        return ret.toString();
    }

    public String[] grep(Object[] search) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < search.length; ++i) {
            String s = search[i].toString();
            if (!this.match(s)) continue;
            v.addElement(s);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private boolean isNewline(int i) {
        if (i < NEWLINE.length() - 1) {
            return false;
        }
        if (this.search.charAt(i) == '\n') {
            return true;
        }
        int j = NEWLINE.length() - 1;
        while (j >= 0) {
            if (NEWLINE.charAt(j) != this.search.charAt(i)) {
                return false;
            }
            --j;
            --i;
        }
        return true;
    }
}

