/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.AttrImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultDocument;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.TextImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName element, XMLAttributes attributes, int line, int column) {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, node);
        this.parent = node;
    }

    public void emptyElement(QName element, XMLAttributes attributes, int line, int column) {
        ElementImpl node = new ElementImpl(line, column);
        this.processElement(element, attributes, node);
    }

    private void processElement(QName element, XMLAttributes attributes, ElementImpl node) {
        node.prefix = element.prefix;
        node.localpart = element.localpart;
        node.rawname = element.rawname;
        node.uri = element.uri;
        node.schemaDOM = this;
        Attr[] attrs = new Attr[attributes.getLength()];
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrs[i] = new AttrImpl(null, attributes.getPrefix(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i));
        }
        node.attrs = attrs;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean foundPlace = false;
        int i = 1;
        for (i = 1; i < this.relations[this.currLoc].length; ++i) {
            if (this.relations[this.currLoc][i] != null) continue;
            foundPlace = true;
            break;
        }
        if (!foundPlace) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][i] = node;
        this.parent.parentRow = this.currLoc;
        node.row = this.currLoc;
        node.col = i;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString text) {
        this.fAnnotationBuffer.append("<!--").append(text.toString()).append("-->");
    }

    void processingInstruction(String target, String data) {
        this.fAnnotationBuffer.append("<?").append(target).append(" ").append(data).append("?>");
    }

    void characters(XMLString text) {
        for (int i = text.offset; i < text.offset + text.length; ++i) {
            if (text.ch[i] == '&') {
                this.fAnnotationBuffer.append("&amp;");
                continue;
            }
            if (text.ch[i] == '<') {
                this.fAnnotationBuffer.append("&lt;");
                continue;
            }
            this.fAnnotationBuffer.append(text.ch[i]);
        }
    }

    void endAnnotationElement(QName elemName, boolean complete) {
        if (complete) {
            int i;
            this.fAnnotationBuffer.append("\n</").append(elemName.rawname).append(">");
            ElementImpl child = (ElementImpl)this.relations[this.currLoc][1];
            if (this.nextFreeLoc == this.relations.length) {
                this.resizeRelations();
            }
            child.parentRow = this.nextFreeLoc++;
            int newRow = child.parentRow;
            boolean foundPlace = false;
            for (i = 1; i < this.relations[newRow].length; ++i) {
                if (this.relations[newRow][i] != null) continue;
                foundPlace = true;
                break;
            }
            if (!foundPlace) {
                this.resizeRelations(newRow);
            }
            this.relations[newRow][i] = new TextImpl(this.fAnnotationBuffer, this, newRow, i);
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(elemName.rawname).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
    }

    private void resizeRelations() {
        NodeImpl[][] temp = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, temp, 0, this.relations.length);
        for (int i = this.relations.length; i < temp.length; ++i) {
            temp[i] = new NodeImpl[10];
        }
        this.relations = temp;
    }

    private void resizeRelations(int i) {
        NodeImpl[] temp = new NodeImpl[this.relations[i].length + 10];
        System.arraycopy(this.relations[i], 0, temp, 0, this.relations[i].length);
        this.relations[i] = temp;
    }

    public void reset() {
        int i;
        if (this.relations != null) {
            for (i = 0; i < this.relations.length; ++i) {
                for (int j = 0; j < this.relations[i].length; ++j) {
                    this.relations[i][j] = null;
                }
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        for (i = 0; i < 15; ++i) {
            this.relations[i] = new NodeImpl[10];
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int depth) {
        SchemaDOM.indent(depth);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                System.out.print("  " + ((Attr)attrs.item(i)).getName() + "=\"" + ((Attr)attrs.item(i)).getValue() + "\"");
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            depth += 4;
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                SchemaDOM.traverse(child, depth);
            }
            SchemaDOM.indent(depth -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int amount) {
        for (int i = 0; i < amount; ++i) {
            System.out.print(' ');
        }
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    void startAnnotation(QName elemName, XMLAttributes attributes, NamespaceContext namespaceContext) {
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(elemName.rawname).append(" ");
        Vector<String> namespaces = new Vector<String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aValue = attributes.getValue(i);
            String aPrefix = attributes.getPrefix(i);
            namespaces.addElement(aValue);
            this.fAnnotationBuffer.append(attributes.getQName(i)).append("=\"").append(aValue).append("\" ");
        }
        Enumeration currPrefixes = namespaceContext.getAllPrefixes();
        while (currPrefixes.hasMoreElements()) {
            String prefix = (String)currPrefixes.nextElement();
            String uri = namespaceContext.getURI(prefix);
            if (namespaces.contains(uri)) continue;
            if (prefix == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(uri).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(prefix).append("=\"").append(uri).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName elemName, XMLAttributes attributes) {
        this.fAnnotationBuffer.append("<").append(elemName.rawname).append(" ");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aValue = attributes.getValue(i);
            this.fAnnotationBuffer.append(" ").append(attributes.getQName(i)).append("=\"").append(SchemaDOM.processAttValue(aValue)).append("\" ");
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String original) {
        StringBuffer newVal = new StringBuffer(original.length());
        for (int i = 0; i < original.length(); ++i) {
            char currChar = original.charAt(i);
            if (currChar == '\"') {
                newVal.append("&quot;");
                continue;
            }
            if (currChar == '>') {
                newVal.append("&gt;");
                continue;
            }
            if (currChar == '&') {
                newVal.append("&amp;");
                continue;
            }
            newVal.append(currChar);
        }
        return newVal.toString();
    }
}

