/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import java.util.Locale;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DefaultValidationErrorHandler
extends DefaultHandler {
    private static int ERROR_COUNT_LIMIT = 10;
    private int errorCount = 0;

    DefaultValidationErrorHandler() {
    }

    public void error(SAXParseException e) throws SAXException {
        String systemId;
        if (this.errorCount >= ERROR_COUNT_LIMIT) {
            return;
        }
        if (this.errorCount == 0) {
            System.err.println(SAXMessageFormatter.formatMessage(Locale.getDefault(), "errorHandlerNotSet", new Object[]{String.valueOf(ERROR_COUNT_LIMIT)}));
        }
        if ((systemId = e.getSystemId()) == null) {
            systemId = "null";
        }
        System.err.println(SAXMessageFormatter.formatMessage(Locale.getDefault(), "errorHandlerDebugMsg", new Object[]{systemId, String.valueOf(e.getLineNumber()), e.getMessage()}));
        ++this.errorCount;
    }
}

